/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.common.frameworks.internal.AdaptabilityUtility;
import org.eclipse.wst.common.frameworks.internal.WTPResourceHandler;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementManager;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.ComposedExtendedOperationHolder;
import org.eclipse.wst.common.frameworks.internal.operations.ComposedOperation;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.operations.OperationExtensionRegistry;
import org.eclipse.wst.common.frameworks.internal.operations.OperationStatus;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public abstract class WTPOperation
implements IHeadlessRunnableWithProgress {
    private static Hashtable threadToExtendedOpControl;
    protected WTPOperationDataModel operationDataModel;
    private OperationStatus opStatus;
    private String id;
    static /* synthetic */ Class class$0;

    public WTPOperation(WTPOperationDataModel operationDataModel) {
        this.setOperationDataModel(operationDataModel);
    }

    public WTPOperation() {
    }

    public final void setID(String value) {
        Assert.isTrue((this.id == null ? 1 : 0) != 0, (String)WTPResourceHandler.getString("22"));
        Assert.isNotNull((Object)value, (String)WTPResourceHandler.getString("23"));
        this.id = value;
    }

    public final String getID() {
        return this.id;
    }

    public final void setOperationDataModel(WTPOperationDataModel operationDataModel) {
        this.operationDataModel = operationDataModel;
    }

    public final WTPOperationDataModel getOperationDataModel() {
        return this.operationDataModel;
    }

    public IStatus getStatus() {
        if (this.opStatus == null) {
            return WTPCommonPlugin.OK_STATUS;
        }
        return this.opStatus;
    }

    protected abstract void execute(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

    protected void initialize(IProgressMonitor monitor) {
        this.opStatus = null;
    }

    private ComposedExtendedOperationHolder initializeExtensionOperations() {
        return OperationExtensionRegistry.getExtensions(this);
    }

    protected void dispose(IProgressMonitor monitor) {
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public WTPOperation append(WTPOperation op) {
        ComposedOperation composedOp = new ComposedOperation();
        composedOp.addRunnable(this);
        composedOp.addRunnable(op);
        return composedOp;
    }

    public final synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final InvocationTargetException[] iteHolder = new InvocationTargetException[1];
        try {
            IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        WTPOperation.this.doRun(pm);
                        if (WTPOperation.this.opStatus != null && !WTPOperation.this.opStatus.isOK()) {
                            System.out.println(WTPOperation.this.opStatus.getMessage());
                        }
                    }
                    catch (InvocationTargetException e) {
                        iteHolder[0] = e;
                    }
                    catch (InterruptedException e) {
                        throw new OperationCanceledException(e.getMessage());
                    }
                }
            };
            ISchedulingRule rule = this.getSchedulingRule();
            if (rule == null) {
                ResourcesPlugin.getWorkspace().run(workspaceRunnable, monitor);
            } else {
                ResourcesPlugin.getWorkspace().run(workspaceRunnable, rule, 0, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 76) {
                throw new WFTWrappedException(e.getStatus().getException(), e.getMessage());
            }
            throw new WFTWrappedException((Throwable)e);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        if (iteHolder[0] != null) {
            throw new WFTWrappedException(iteHolder[0].getTargetException(), iteHolder[0].getMessage());
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doRun(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        boolean operationValidationEnabled;
        boolean alreadyLocked;
        boolean rootOperation;
        Thread currentThread;
        block21: {
            block20: {
                block19: {
                    if (threadToExtendedOpControl == null) {
                        threadToExtendedOpControl = new Hashtable();
                    }
                    rootOperation = !threadToExtendedOpControl.containsKey(currentThread = Thread.currentThread());
                    alreadyLocked = this.operationDataModel == null ? true : this.operationDataModel.isLocked();
                    operationValidationEnabled = this.operationDataModel == null ? false : this.operationDataModel.isOperationValidationEnabled();
                    try {
                        if (rootOperation) {
                            boolean allowExtensions = this.operationDataModel == null ? true : this.operationDataModel.getBooleanProperty("WTPOperationDataModel.ALLOW_EXTENSIONS");
                            List restrictedExtensions = this.operationDataModel == null ? Collections.EMPTY_LIST : (List)this.operationDataModel.getProperty("WTPOperationDataModel.RESTRICT_EXTENSIONS");
                            ExtendedOpControl extendedOpControl = new ExtendedOpControl(allowExtensions, restrictedExtensions);
                            threadToExtendedOpControl.put(currentThread, extendedOpControl);
                        }
                        if (!alreadyLocked) {
                            this.operationDataModel.setLocked(true);
                        }
                        if (operationValidationEnabled) {
                            this.operationDataModel.setOperationValidationEnabled(false);
                            IStatus status = this.operationDataModel.validateDataModel();
                            if (!status.isOK()) {
                                System.out.println(WTPResourceHandler.getString("24", new Object[]{status.getMessage()}));
                                Thread.dumpStack();
                                Object var9_11 = null;
                                this.dispose(monitor);
                                if (rootOperation) {
                                    threadToExtendedOpControl.remove(currentThread);
                                }
                                break block19;
                            }
                        }
                        this.initialize(monitor);
                        if (!this.validateEdit()) {
                            break block20;
                        }
                        ComposedExtendedOperationHolder extOpHolder = this.initializeExtensionOperations();
                        IStatus preOpStatus = this.runPreOps(monitor, extOpHolder);
                        this.execute(monitor);
                        IStatus postOpStatus = this.runPostOps(monitor, extOpHolder);
                        if (preOpStatus != null) {
                            this.addExtendedStatus(preOpStatus);
                        }
                        if (postOpStatus != null) {
                            this.addExtendedStatus(postOpStatus);
                        }
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        this.dispose(monitor);
                        if (rootOperation) {
                            threadToExtendedOpControl.remove(currentThread);
                        }
                        if (!alreadyLocked) {
                            this.operationDataModel.setLocked(false);
                        }
                        if (!operationValidationEnabled) throw throwable;
                        this.operationDataModel.setOperationValidationEnabled(true);
                        throw throwable;
                    }
                }
                if (!alreadyLocked) {
                    this.operationDataModel.setLocked(false);
                }
                if (!operationValidationEnabled) return;
                this.operationDataModel.setOperationValidationEnabled(true);
                return;
            }
            Object var9_12 = null;
            this.dispose(monitor);
            if (rootOperation) {
                threadToExtendedOpControl.remove(currentThread);
            }
            if (!alreadyLocked) {
                this.operationDataModel.setLocked(false);
            }
            if (!operationValidationEnabled) return;
            this.operationDataModel.setOperationValidationEnabled(true);
            return;
        }
        Object var9_14 = null;
        this.dispose(monitor);
        if (rootOperation) {
            threadToExtendedOpControl.remove(currentThread);
        }
        if (!alreadyLocked) {
            this.operationDataModel.setLocked(false);
        }
        if (!operationValidationEnabled) return;
        this.operationDataModel.setOperationValidationEnabled(true);
    }

    protected boolean validateEdit() {
        return true;
    }

    public final void addStatus(IStatus aStatus) {
        if (this.opStatus == null) {
            this.opStatus = new OperationStatus(aStatus.getMessage(), aStatus.getException());
            this.opStatus.setSeverity(aStatus.getSeverity());
            this.opStatus.add(aStatus);
        } else {
            this.opStatus.add(aStatus);
        }
    }

    private void addExtendedStatus(IStatus aStatus) {
        if (this.opStatus == null) {
            this.opStatus = new OperationStatus(new IStatus[]{WTPCommonPlugin.OK_STATUS});
        }
        this.opStatus.addExtendedStatus(aStatus);
    }

    private IStatus runPostOps(IProgressMonitor pm, ComposedExtendedOperationHolder extOpHolder) {
        IStatus postOpStatus = null;
        if (extOpHolder != null && extOpHolder.hasPostOps()) {
            postOpStatus = this.runExtendedOps(extOpHolder.getPostOps(), pm);
        }
        return postOpStatus;
    }

    private IStatus runPreOps(IProgressMonitor pm, ComposedExtendedOperationHolder extOpHolder) {
        IStatus preOpStatus = null;
        if (extOpHolder != null && extOpHolder.hasPreOps()) {
            preOpStatus = this.runExtendedOps(extOpHolder.getPreOps(), pm);
        }
        return preOpStatus;
    }

    private IStatus runExtendedOps(List opList, IProgressMonitor pm) {
        WTPOperation op = null;
        OperationStatus returnStatus = null;
        String opId = null;
        ExtendedOpControl opControl = (ExtendedOpControl)threadToExtendedOpControl.get(Thread.currentThread());
        int i = 0;
        while (i < opList.size()) {
            op = (WTPOperation)opList.get(i);
            opId = op.getID();
            if (opControl.shouldExecute(op.getClass().getName()) && opControl.shouldExecute(opId)) {
                Status localStatus;
                try {
                    boolean shouldExtendedRun = true;
                    List extendedContext = (List)this.operationDataModel.getProperty("WTPOperationDataModel.EXTENDED_CONTEXT");
                    int contextCount = 0;
                    while (shouldExtendedRun && contextCount < extendedContext.size()) {
                        IProject project;
                        Object e = extendedContext.get(contextCount);
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IProject");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((project = (IProject)AdaptabilityUtility.getAdapter(e, clazz)) != null && !IEnablementManager.INSTANCE.getIdentifier(opId, project).isEnabled()) {
                            shouldExtendedRun = false;
                        }
                        ++contextCount;
                    }
                    if (shouldExtendedRun) {
                        op.setOperationDataModel(this.operationDataModel);
                        op.doRun((IProgressMonitor)new SubProgressMonitor(pm, -1));
                        localStatus = op.getStatus();
                    } else {
                        localStatus = null;
                    }
                }
                catch (Exception e) {
                    localStatus = new Status(4, "org.eclipse.wst.common.frameworks", 0, WTPResourceHandler.getString("25", new Object[]{op.getClass().getName()}), (Throwable)e);
                }
                if (localStatus != null) {
                    if (returnStatus == null) {
                        returnStatus = new OperationStatus(new IStatus[]{localStatus});
                    } else {
                        returnStatus.add((IStatus)localStatus);
                    }
                }
            }
            ++i;
        }
        return returnStatus;
    }

    protected static final void runNestedDefaultOperation(WTPOperationDataModel model, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        WTPOperation op = model.getDefaultOperation();
        if (op != null) {
            op.run(monitor);
        }
    }

    private class ExtendedOpControl {
        private boolean allowExtensions;
        List restrictedExtensions;

        public ExtendedOpControl(boolean allowExtensions, List restrictedExtensions) {
            this.allowExtensions = allowExtensions;
            this.restrictedExtensions = restrictedExtensions;
        }

        public boolean shouldExecute(String operationID) {
            return this.allowExtensions && !this.restrictedExtensions.contains(operationID);
        }
    }
}

