/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.ecore2xml.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcoreMappingRoot;
import org.eclipse.emf.mapping.ecore2ecore.Ecore2EcorePackage;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLFactory;
import org.eclipse.emf.mapping.ecore2xml.XMLInfo;
import org.eclipse.emf.mapping.ecore2xml.XMLMap;
import org.eclipse.emf.mapping.ecore2xml.ui.Ecore2XMLUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class GenerateEcore2XMLActionDelegate
extends ActionDelegate {
    private static final String ECORE2ECORE_FILE_EXTENSION = "ecore2ecore";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Ecore2EcoreMappingRoot getMappingRoot(IStructuredSelection structuredSelection) {
        IFile file;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(structuredSelection.getFirstElement()) && ECORE2ECORE_FILE_EXTENSION.equals((file = (IFile)structuredSelection.getFirstElement()).getFullPath().getFileExtension())) {
            return (Ecore2EcoreMappingRoot)EcoreUtil.getObjectByType((Collection)new ResourceSetImpl().getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true).getContents(), (EClassifier)Ecore2EcorePackage.eINSTANCE.getEcore2EcoreMappingRoot());
        }
        return null;
    }

    protected static XMLResource.XMLInfo createXMLInfo(EObject eObject) {
        return (XMLResource.XMLInfo)new EcoreSwitch(){

            public Object caseEPackage(EPackage ePackage) {
                XMLInfo xmlInfo = Ecore2XMLFactory.eINSTANCE.createXMLInfo();
                xmlInfo.setName(ePackage.getName());
                xmlInfo.setTargetNamespace(ExtendedMetaData.INSTANCE.getNamespace(ePackage));
                return xmlInfo;
            }

            public Object caseEClassifier(EClassifier eClassifier) {
                XMLInfo xmlInfo = Ecore2XMLFactory.eINSTANCE.createXMLInfo();
                xmlInfo.setName(ExtendedMetaData.INSTANCE.getName(eClassifier));
                xmlInfo.setTargetNamespace(ExtendedMetaData.INSTANCE.getNamespace(eClassifier));
                return xmlInfo;
            }

            public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                XMLInfo xmlInfo = Ecore2XMLFactory.eINSTANCE.createXMLInfo();
                xmlInfo.setName(ExtendedMetaData.INSTANCE.getName(eStructuralFeature));
                xmlInfo.setTargetNamespace(ExtendedMetaData.INSTANCE.getNamespace(eStructuralFeature));
                switch (ExtendedMetaData.INSTANCE.getFeatureKind(eStructuralFeature)) {
                    case 2: {
                        xmlInfo.setXMLRepresentation(1);
                        break;
                    }
                    case 4: {
                        xmlInfo.setXMLRepresentation(0);
                    }
                }
                return xmlInfo;
            }
        }.doSwitch(eObject);
    }

    protected static XMLResource.XMLMap createXMLMap(Ecore2EcoreMappingRoot mappingRoot) {
        XMLMap xmlMap = Ecore2XMLFactory.eINSTANCE.createXMLMap();
        TreeIterator mappings = mappingRoot.treeIterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            if (mapping.getInputs().isEmpty()) continue;
            EObject input = (EObject)mapping.getInputs().get(0);
            Iterator outputs = mapping.getOutputs().iterator();
            while (outputs.hasNext()) {
                ENamedElement output = (ENamedElement)outputs.next();
                XMLResource.XMLInfo xmlInfo = GenerateEcore2XMLActionDelegate.createXMLInfo(input);
                if (xmlInfo == null) continue;
                xmlMap.add(output, xmlInfo);
            }
        }
        return xmlMap;
    }

    protected IFile getFile(Resource resource) {
        URI uri = resource.getURI();
        uri = resource.getResourceSet().getURIConverter().normalize(uri);
        String scheme = uri.scheme();
        if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(j));
                ++j;
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
        }
        return null;
    }

    public void run(IAction action) {
        final IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            new ProgressMonitorDialog(workbenchWindow.getShell()).run(false, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        progressMonitor.beginTask("", -1);
                        Ecore2EcoreMappingRoot mappingRoot = GenerateEcore2XMLActionDelegate.this.getMappingRoot((IStructuredSelection)workbenchWindow.getSelectionService().getSelection());
                        if (mappingRoot != null) {
                            Resource ecore2ecoreResource = mappingRoot.eResource();
                            URI ecore2xmlURI = ecore2ecoreResource.getURI().trimFileExtension().appendFileExtension("ecore2xml");
                            Resource ecore2xmlResource = ecore2ecoreResource.getResourceSet().createResource(ecore2xmlURI);
                            ecore2xmlResource.getContents().add((Object)GenerateEcore2XMLActionDelegate.createXMLMap(mappingRoot));
                            try {
                                ecore2xmlResource.save(null);
                                IFile file = GenerateEcore2XMLActionDelegate.this.getFile(ecore2xmlResource);
                                IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
                                IWorkbenchPart activePart = workbenchPage.getActivePart();
                                if (activePart instanceof ISetSelectionTarget) {
                                    StructuredSelection targetSelection = new StructuredSelection((Object)file);
                                    workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(this, activePart, (ISelection)targetSelection){
                                        final /* synthetic */ 2 this$1;
                                        private final /* synthetic */ IWorkbenchPart val$activePart;
                                        private final /* synthetic */ ISelection val$targetSelection;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$activePart = iWorkbenchPart;
                                            this.val$targetSelection = iSelection;
                                        }

                                        public void run() {
                                            ((ISetSelectionTarget)this.val$activePart).selectReveal(this.val$targetSelection);
                                        }
                                    });
                                }
                                try {
                                    workbenchPage.openEditor((IEditorInput)new FileEditorInput(file), workbenchWindow.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId());
                                }
                                catch (PartInitException pie) {
                                    Ecore2XMLUIPlugin.INSTANCE.log((Object)pie);
                                }
                            }
                            catch (IOException ioe) {
                                Ecore2XMLUIPlugin.INSTANCE.log(ioe);
                            }
                        }
                        Object var10_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ite) {
            Ecore2XMLUIPlugin.INSTANCE.log(ite);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.viewers.IStructuredSelection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setEnabled(clazz.isInstance(selection) && this.getMappingRoot((IStructuredSelection)selection) != null);
    }
}

