/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.sqlscrapbook.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.sqlscrapbook.util.NodeSQLPage;
import org.eclipse.wst.rdb.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.wst.rdb.server.internal.ui.services.IServerExplorerContentService;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SQLUtility {
    public static ConnectionInfo getConnectionInfo(String nameConnection) {
        IServerExplorerContentService service = IServicesManager.INSTANCE.getServerExplorerContentService();
        if (service == null) {
            return null;
        }
        Object[] servers = service.getKnownServerNode().getChildrenArray();
        ConnectionInfo connection = null;
        int i = 0;
        while (i < servers.length) {
            IConnectionNode node = (IConnectionNode)servers[i];
            ConnectionInfo info = node.getConnectionInfo();
            if (info.getName().equals(nameConnection)) {
                connection = node.getConnectionInfo();
                if (node.isConnected()) break;
                new ServerExplorerConfiguration().restoreConnectionInfo(node, node.getConnectionInfo());
                break;
            }
            ++i;
        }
        return connection;
    }

    public static ConnectionInfo getConnectionInfo(String userid, String url, String driver, String password) {
        IServerExplorerContentService service = IServicesManager.INSTANCE.getServerExplorerContentService();
        if (service == null) {
            return null;
        }
        Object[] servers = service.getKnownServerNode().getChildrenArray();
        ConnectionInfo connection = null;
        int i = 0;
        while (i < servers.length) {
            IConnectionNode node = (IConnectionNode)servers[i];
            ConnectionInfo info = node.getConnectionInfo();
            if (info.getUserName().equals(userid) && info.getURL().equals(url) && info.getDriverClassName().equals(driver)) {
                connection = node.getConnectionInfo();
                break;
            }
            ++i;
        }
        return connection;
    }

    public static String getOutputSQLPageXML(String inStatement, Map map) {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        DOMImplementation impl = builder.getDOMImplementation();
        doc = impl.createDocument(null, "SQLPage", null);
        Element root = doc.getDocumentElement();
        map.entrySet().iterator();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry element = it.next();
            if (!(element instanceof Map.Entry)) continue;
            String key = (String)element.getKey();
            String value = (String)element.getValue();
            Attr attr = doc.createAttribute(key);
            attr.setValue(value);
            root.setAttributeNode(attr);
        }
        Element item = doc.createElement("Statement");
        if (inStatement == null) {
            inStatement = "";
        }
        item.appendChild(doc.createCDATASection(inStatement));
        root.appendChild(item);
        StringWriter stringOut = new StringWriter();
        DOMSource domSource = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(stringOut);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = null;
        try {
            serializer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        serializer.setOutputProperty("indent", "yes");
        try {
            serializer.transform(domSource, streamResult);
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
        return stringOut.toString();
    }

    public static NodeSQLPage getInputSQLPageXML(File fileXMLin) {
        Document xmlDocument = null;
        NodeSQLPage nodeSQLPage = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            xmlDocument = builder.parse(fileXMLin);
            Element xmlElement = xmlDocument.getDocumentElement();
            xmlElement.getNodeName();
            if (!xmlElement.getNodeName().equals("SQLPage")) {
                return null;
            }
            NodeSQLPage new_nodeSQLPage = new NodeSQLPage();
            new_nodeSQLPage.setNameConnection(xmlElement.getAttribute("nameConnection"));
            NodeList nodeList = xmlElement.getChildNodes();
            int i = 0;
            block5: while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals("Statement")) {
                    Element statementElement = (Element)node;
                    NodeList statementNodeList = statementElement.getChildNodes();
                    int j = 0;
                    while (j < statementNodeList.getLength()) {
                        Node nodeSQL = statementNodeList.item(j);
                        if (nodeSQL.getNodeType() == 4) {
                            new_nodeSQLPage.setStatementSQL(nodeSQL.getNodeValue());
                            break block5;
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
            nodeSQLPage = new_nodeSQLPage;
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nodeSQLPage;
    }
}

