/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.projection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jst.jsp.ui.internal.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.html.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Node;

public class ProjectionModelNodeAdapterHTML
implements INodeAdapter {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.html.ui/projectionperf"));
    ProjectionModelNodeAdapterFactoryHTML fAdapterFactory;
    private Map fTagAnnotations = new HashMap();
    static /* synthetic */ Class class$0;

    public ProjectionModelNodeAdapterHTML(ProjectionModelNodeAdapterFactoryHTML factory) {
        this.fAdapterFactory = factory;
    }

    private Position createProjectionPosition(Node node) {
        IDocument document;
        Position pos = null;
        if (this.fAdapterFactory.isNodeProjectable(node) && node instanceof IndexedRegion && (document = this.fAdapterFactory.getProjectionViewer().getDocument()) != null) {
            IndexedRegion inode = (IndexedRegion)node;
            int start = inode.getStartOffset();
            int end = inode.getEndOffset();
            if (start >= 0 && start < end) {
                try {
                    int startLine = document.getLineOfOffset(start);
                    int endLine = document.getLineOfOffset(end);
                    if (endLine + 1 < document.getNumberOfLines()) {
                        int offset = document.getLineOffset(startLine);
                        int endOffset = document.getLineOffset(endLine + 1);
                        pos = new Position(offset, endOffset - offset);
                    }
                }
                catch (BadLocationException x) {
                    Logger.log((int)202, null, (Throwable)x);
                }
            }
        }
        return pos;
    }

    private TagProjectionAnnotation getExistingAnnotation(Node node) {
        TagProjectionAnnotation anno = null;
        if (node != null && !this.fTagAnnotations.isEmpty()) {
            Iterator it = this.fTagAnnotations.keySet().iterator();
            while (it.hasNext() && anno == null) {
                TagProjectionAnnotation a = (TagProjectionAnnotation)((Object)it.next());
                Node n = a.getNode();
                if (!node.equals(n)) continue;
                anno = a;
            }
        }
        return anno;
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.ui.internal.projection.ProjectionModelNodeAdapterHTML");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (this.fAdapterFactory.getProjectionViewer() == null) {
            return;
        }
        if (eventType == 4 && notifier instanceof Node) {
            this.updateAdapter((Node)notifier);
        }
    }

    void updateAdapter(Node node) {
        long start = System.currentTimeMillis();
        HashMap<TagProjectionAnnotation, Position> additions = new HashMap<TagProjectionAnnotation, Position>();
        HashMap<TagProjectionAnnotation, Position> projectionAnnotations = new HashMap<TagProjectionAnnotation, Position>();
        if (node != null) {
            Node childNode = node.getFirstChild();
            while (childNode != null) {
                Position newPos = this.createProjectionPosition(childNode);
                if (newPos != null) {
                    TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation(childNode, false);
                    TagProjectionAnnotation existing = this.getExistingAnnotation(childNode);
                    if (existing == null) {
                        projectionAnnotations.put(newAnnotation, newPos);
                        additions.put(newAnnotation, newPos);
                    } else {
                        projectionAnnotations.put(existing, newPos);
                        this.fTagAnnotations.remove((Object)existing);
                    }
                }
                childNode = childNode.getNextSibling();
            }
            ProjectionAnnotation[] oldList = null;
            if (!this.fTagAnnotations.isEmpty()) {
                oldList = this.fTagAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            ProjectionAnnotation[] modifyList = null;
            if (!projectionAnnotations.isEmpty()) {
                modifyList = projectionAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            ProjectionViewer viewer = this.fAdapterFactory.getProjectionViewer();
            ProjectionAnnotationModel annotationModel = viewer.getProjectionAnnotationModel();
            annotationModel.modifyAnnotations((Annotation[])oldList, additions, (Annotation[])modifyList);
        }
        this.fTagAnnotations = additions;
        long end = System.currentTimeMillis();
        if (debugProjectionPerf) {
            String nodeName = node != null ? node.getNodeName() : "null";
            System.out.println("ProjectionModelNodeAdapterHTML.updateAdapter (" + nodeName + "):" + (end - start));
        }
    }

    private class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible = false;
        private Node fNode;

        public TagProjectionAnnotation(Node node, boolean isCollapsed) {
            super(isCollapsed);
            this.fNode = node;
        }

        public Node getNode() {
            return this.fNode;
        }

        public void setNode(Node node) {
            this.fNode = node;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            int lineHeight;
            if (!this.isCollapsed() && rectangle.height / (lineHeight = ProjectionModelNodeAdapterHTML.this.fAdapterFactory.getProjectionViewer().getTextWidget().getLineHeight()) <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }
    }
}

