/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchScope;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.java.search.JSPOccurrencesSearchResult;
import org.eclipse.jst.jsp.ui.internal.java.search.JSPSingleFileSearchRequestor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchQuery;

public class JSPSearchQuery
extends BasicSearchQuery {
    private IJavaElement fElement = null;

    public JSPSearchQuery(IFile file, IJavaElement element) {
        super(file);
        this.fElement = element;
    }

    public IJavaElement getJavaElement() {
        return this.fElement;
    }

    public JSPSearchQuery getInstance() {
        return this;
    }

    protected IWorkspaceRunnable getRunnable() {
        return new SingleFileSearch();
    }

    protected IStatus doQuery() {
        this.clearMatches();
        IStatus status = Status.OK_STATUS;
        try {
            JSPSearchSupport support = JSPSearchSupport.getInstance();
            SearchDocument delegate = support.addJspFile(this.getFile());
            String scopePath = delegate.getPath();
            JSPSearchScope singleFileScope = new JSPSearchScope(new String[]{this.getFile().getFullPath().toString(), scopePath});
            support.searchRunnable(this.getJavaElement(), (IJavaSearchScope)singleFileScope, (SearchRequestor)new JSPSingleFileSearchRequestor(this.getInstance()));
        }
        catch (Exception exception) {
            status = new Status(4, "org.eclipse.wst.sse.ui", 0, "", null);
        }
        return status;
    }

    public String getLabel() {
        Object[] args = new String[]{this.getSearchText(), this.getOccurrencesCountText(), this.getFilename()};
        return NLS.bind((String)JSPUIMessages.OccurrencesSearchQuery_0, (Object[])args);
    }

    private String getFilename() {
        String filename = JSPUIMessages.OccurrencesSearchQuery_2;
        if (this.getFile() != null) {
            filename = this.getFile().getName();
        }
        return filename;
    }

    private String getOccurrencesCountText() {
        String count = "";
        return count;
    }

    protected String getSearchText() {
        return this.fElement.getElementName();
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return new JSPOccurrencesSearchResult((ISearchQuery)this);
    }

    private class SingleFileSearch
    implements IWorkspaceRunnable {
        SingleFileSearch() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            if (JSPSearchQuery.this.getFile() != null && JSPSearchQuery.this.getJavaElement() != null) {
                JSPSearchSupport support = JSPSearchSupport.getInstance();
                SearchDocument delegate = support.addJspFile(JSPSearchQuery.this.getFile());
                String scopePath = delegate.getPath();
                JSPSearchScope singleFileScope = new JSPSearchScope(new String[]{JSPSearchQuery.this.getFile().getFullPath().toString(), scopePath});
                support.searchRunnable(JSPSearchQuery.this.getJavaElement(), (IJavaSearchScope)singleFileScope, (SearchRequestor)new JSPSingleFileSearchRequestor(JSPSearchQuery.this.getInstance()));
            }
        }
    }
}

