/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.properties.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.wst.common.ui.properties.internal.CommonUIPropertiesPlugin;

public final class TabbedPropertyRegistryUtils {
    public static IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        IExtensionPoint extensionPoint = CommonUIPropertiesPlugin.getPlugin().getDescriptor().getExtensionPoint(extensionPointId);
        if (extensionPoint == null) {
            return null;
        }
        return extensionPoint.getConfigurationElements();
    }

    public static IPluginDescriptor[] getPluginDescriptors(Collection configurationElements) {
        HashSet<IPluginDescriptor> result = new HashSet<IPluginDescriptor>(configurationElements.size());
        Iterator iter = configurationElements.iterator();
        while (iter.hasNext()) {
            IConfigurationElement element = (IConfigurationElement)iter.next();
            result.add(element.getDeclaringExtension().getDeclaringPluginDescriptor());
        }
        return result.toArray(new IPluginDescriptor[result.size()]);
    }

    public static String[] computePrerequisiteOrder(IPluginDescriptor[] plugins) {
        String[] orderedPlugins = TabbedPropertyRegistryUtils.computePrerequisiteOrderPlugins(plugins);
        return orderedPlugins;
    }

    private static String[] computePrerequisiteOrderPlugins(IPluginDescriptor[] plugins) {
        ArrayList<String[]> prereqs = new ArrayList<String[]>(9);
        HashSet<String> pluginList = new HashSet<String>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            pluginList.add(plugins[i].getUniqueIdentifier());
            ++i;
        }
        i = 0;
        while (i < plugins.length) {
            boolean boot = false;
            boolean runtime = false;
            boolean found = false;
            IPluginPrerequisite[] prereqList = plugins[i].getPluginPrerequisites();
            if (prereqList != null) {
                int j = 0;
                while (j < prereqList.length) {
                    String prereq = prereqList[j].getUniqueIdentifier();
                    boot = boot || prereq.equals("org.eclipse.core.boot");
                    boolean bl = runtime = runtime || prereq.equals("org.eclipse.core.runtime");
                    if (pluginList.contains(prereq)) {
                        found = true;
                        prereqs.add(new String[]{plugins[i].getUniqueIdentifier(), prereq});
                    }
                    ++j;
                }
            }
            if (!found) {
                String[] stringArray = new String[2];
                stringArray[0] = plugins[i].getUniqueIdentifier();
                prereqs.add(stringArray);
            }
            ++i;
        }
        String[][] prereqArray = (String[][])prereqs.toArray((T[])new String[prereqs.size()][]);
        return TabbedPropertyRegistryUtils.computeNodeOrder(prereqArray);
    }

    private static String[] computeNodeOrder(String[][] specs) {
        HashMap counts = TabbedPropertyRegistryUtils.computeCounts(specs);
        ArrayList nodes = new ArrayList(counts.size());
        while (!counts.isEmpty()) {
            List roots = TabbedPropertyRegistryUtils.findRootNodes(counts);
            if (roots.isEmpty()) break;
            Iterator i = roots.iterator();
            while (i.hasNext()) {
                counts.remove(i.next());
            }
            nodes.addAll(roots);
            TabbedPropertyRegistryUtils.removeArcs(specs, roots, counts);
        }
        String[] result = new String[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    private static HashMap computeCounts(String[][] mappings) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>(5);
        int i = 0;
        while (i < mappings.length) {
            String from = mappings[i][0];
            Integer fromCount = (Integer)counts.get(from);
            String to = mappings[i][1];
            if (to == null) {
                counts.put(from, new Integer(0));
            } else {
                if ((Integer)counts.get(to) == null) {
                    counts.put(to, new Integer(0));
                }
                fromCount = fromCount == null ? new Integer(1) : new Integer(fromCount + 1);
                counts.put(from, fromCount);
            }
            ++i;
        }
        return counts;
    }

    private static List findRootNodes(Map counts) {
        ArrayList<String> result = new ArrayList<String>(5);
        Iterator i = counts.keySet().iterator();
        while (i.hasNext()) {
            String node = (String)i.next();
            int count = (Integer)counts.get(node);
            if (count != 0) continue;
            result.add(node);
        }
        return result;
    }

    private static void removeArcs(String[][] mappings, List roots, Map counts) {
        Iterator j = roots.iterator();
        while (j.hasNext()) {
            String root = (String)j.next();
            int i = 0;
            while (i < mappings.length) {
                String input;
                Integer count;
                if (root.equals(mappings[i][1]) && (count = (Integer)counts.get(input = mappings[i][0])) != null) {
                    counts.put(input, new Integer(count - 1));
                }
                ++i;
            }
        }
    }
}

