/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.web.operations.J2EEWebNatureRuntime;
import org.eclipse.jst.j2ee.internal.web.operations.WebProjectInfo;
import org.eclipse.wst.web.internal.operation.IBaseWebNature;
import org.eclipse.wst.web.internal.operation.StaticWebNatureRuntime;

public class WebNatureRuntimeUtilities {
    protected static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        ProjectUtilities.addNatureToProject((IProject)proj, (String)natureId);
    }

    public static IBaseWebNature createRuntime(WebProjectInfo info) throws CoreException {
        IProject project = info.getProject();
        if (WebNatureRuntimeUtilities.hasRuntime(project)) {
            IBaseWebNature runtime = WebNatureRuntimeUtilities.getRuntime(project);
            if (J2EEWebNatureRuntime.hasRuntime(project)) {
                ((J2EEWebNatureRuntime)runtime).initializeFromInfo(info);
            }
            return runtime;
        }
        if (info.getWebProjectType() == 1) {
            WebNatureRuntimeUtilities.addNatureToProject(project, "org.eclipse.jst.j2ee.web.WebNature");
        } else {
            WebNatureRuntimeUtilities.addNatureToProject(project, "org.eclipse.jst.j2ee.web.StaticWebNature");
        }
        IBaseWebNature runtime = WebNatureRuntimeUtilities.getRuntime(project);
        if (info.getWebProjectType() == 1) {
            ((J2EEWebNatureRuntime)runtime).initializeFromInfo(info);
        }
        return runtime;
    }

    public static IBaseWebNature getRuntime(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            IBaseWebNature nature = project.hasNature("org.eclipse.jst.j2ee.web.WebNature") ? (IBaseWebNature)project.getNature("org.eclipse.jst.j2ee.web.WebNature") : (IBaseWebNature)project.getNature("org.eclipse.wst.web.StaticWebNature");
            return nature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static J2EEWebNatureRuntime getJ2EERuntime(IProject project) {
        IBaseWebNature nature = WebNatureRuntimeUtilities.getRuntime(project);
        if (nature != null && nature.isJ2EE()) {
            return (J2EEWebNatureRuntime)nature;
        }
        return null;
    }

    public static StaticWebNatureRuntime getStaticRuntime(IProject project) {
        IBaseWebNature nature = WebNatureRuntimeUtilities.getRuntime(project);
        if (nature != null && nature.isStatic()) {
            return (StaticWebNatureRuntime)nature;
        }
        return null;
    }

    public static boolean hasRuntime(IProject project) {
        try {
            return project.hasNature("org.eclipse.jst.j2ee.web.WebNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasStaticRuntime(IProject project) {
        if (project == null || !project.exists()) {
            return false;
        }
        try {
            return project.hasNature("org.eclipse.jst.j2ee.web.StaticWebNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasJ2EERuntime(IProject project) {
        if (project == null || !project.exists()) {
            return false;
        }
        try {
            return project.hasNature("org.eclipse.jst.j2ee.web.WebNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static String getDefaultJ2EEWebContentName() {
        return J2EEPlugin.getDefault().getJ2EEPreferences().getJ2EEWebContentFolderName();
    }

    public static String getDefaultStaticWebContentName() {
        return J2EEPlugin.getDefault().getJ2EEPreferences().getStaticWebContentFolderName();
    }

    public static IPath getDefaultJ2EEWebContentPath() {
        return new Path(WebNatureRuntimeUtilities.getDefaultJ2EEWebContentName());
    }

    public static String getContextRootFromWebProject(IProject project) {
        IBaseWebNature nature = WebNatureRuntimeUtilities.getRuntime(project);
        String contextRoot = "";
        contextRoot = nature.getContextRoot();
        return contextRoot;
    }

    public static IPath getDefaultWEBINFPath() {
        return WebNatureRuntimeUtilities.getDefaultJ2EEWebContentPath().append("WEB-INF");
    }

    public static IPath getDefaultWebOutputFolderPath() {
        return WebNatureRuntimeUtilities.getDefaultWEBINFPath().append("classes");
    }

    public static IPath getWebOutputFolderPath(String webContentName) {
        return new Path(webContentName).append("WEB-INF").append("classes");
    }

    public static String getDefaultJavaSourceName() {
        return J2EEPlugin.getDefault().getJ2EEPreferences().getJavaSourceFolderName();
    }
}

