/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.internal.plugin.IJavaProjectInfo;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.internal.J2EEEditModel;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.IWebNatureConstants;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.web.operations.IDynamicWebNature;
import org.eclipse.jst.j2ee.internal.web.operations.RelationData;
import org.eclipse.jst.j2ee.internal.web.operations.WebEditModel;
import org.eclipse.jst.j2ee.internal.web.operations.WebProjectInfo;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibRegistry;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.impl.ComponentCoreURIConverter;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.web.internal.operation.ILibModule;

public class J2EEWebNatureRuntime
extends J2EEModuleNature
implements IDynamicWebNature,
IWebNatureConstants {
    protected static String PROJECTTYPE_J2EE_VALUE = "J2EE";
    private static final String WEB_PROJECT_12_OVERLAY = "1_2_ovr";
    private static final String WEB_PROJECT_13_OVERLAY = "1_3_ovr";
    private static final String WEB_PROJECT_14_OVERLAY = "1_4_ovr";
    public static final String SERVLETLEVEL_2_2 = "Servlet 2.2";
    public static final String SERVLETLEVEL_2_3 = "Servlet 2.3";
    public static final String SERVLETLEVEL_2_4 = "Servlet 2.4";
    public static final String JSPLEVEL_1_1 = "JSP 1.1";
    public static final String JSPLEVEL_1_2 = "JSP 1.2";
    public static final String JSPLEVEL_2_0 = "JSP 2.0";
    public static final String DEFAULT_JSPLEVEL = "JSP 1.1";
    public static final String DEFAULT_SERVLETLEVEL = "Servlet 2.2";
    public static int CURRENT_VERSION = 600;
    public static int instanceCount = 1;
    public int instanceStamp = instanceCount++;
    protected RelationData relationData;
    protected String contextRoot = null;
    protected String jspLevel = null;
    protected String servletLevel = null;
    protected ILibModule[] libModules = null;
    protected String[] featureIds = null;
    protected int fVersion = -1;
    private int fWebNatureType = -1;

    public void addCVSIgnoreFile() {
    }

    public void addLibDirBuilder() throws CoreException {
        this.addToFrontOfBuildSpec("org.eclipse.jst.j2ee.web.LibDirBuilder");
    }

    public int getJ2EEVersion() {
        int j2eeVersion;
        switch (this.getModuleVersion()) {
            case 22: {
                j2eeVersion = 12;
                break;
            }
            case 23: {
                j2eeVersion = 13;
                break;
            }
            default: {
                j2eeVersion = 14;
            }
        }
        return j2eeVersion;
    }

    protected void addToFrontOfBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            IProjectDescription desc = this.getProject().getDescription();
            desc.setBuildSpec(newCommands);
            this.getProject().setDescription(desc, null);
        }
    }

    public Archive asArchive() throws OpenFailureException {
        return null;
    }

    public Archive asArchive(boolean shouldExportSource) throws OpenFailureException {
        return null;
    }

    public void primConfigure() throws CoreException {
        ProjectUtilities.addToBuildSpec((String)"org.eclipse.wst.validation.validationbuilder", (IProject)this.getProject());
        ProjectUtilities.addToBuildSpec((String)"org.eclipse.jst.j2ee.LibCopyBuilder", (IProject)this.getProject());
        this.addLibDirBuilder();
        super.primConfigure();
    }

    protected EditModel createCacheEditModel() {
        return this.getWebAppEditModelForRead(this);
    }

    public void createFile(IPath newFilePath, String newFileContents) throws CoreException {
        IPath projectPath = this.project.getFullPath();
        IWorkspace workspace = J2EEPlugin.getWorkspace();
        this.createFolder(newFilePath.removeLastSegments(1).toString());
        IFile outputFile = workspace.getRoot().getFile(projectPath.append(newFilePath));
        outputFile.refreshLocal(2, null);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(newFileContents.getBytes());
        if (!outputFile.exists()) {
            outputFile.create((InputStream)inputStream, true, null);
        }
    }

    protected void createFolders() throws CoreException {
        this.createFolder(this.getBasicWebModulePath());
        if (this.getWebNatureType() == 1) {
            this.createFolder(this.getMetaPath().toString());
            super.createFolders();
        }
        if (this.getWebNatureType() == 1) {
            this.createFolder(this.getLibraryPath());
        }
    }

    public Module createNewModule() {
        return ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createWebModule();
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.jst.j2ee.web.LibDirBuilder");
        super.deconfigure();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getContextRoot() {
        block9: {
            block8: {
                if (this.contextRoot != null && !this.contextRoot.equals("")) break block9;
                Object artifact = null;
                WebArtifactEdit webEdit = null;
                try {
                    try {
                        webEdit = artifact;
                        if (webEdit != null) {
                            this.contextRoot = webEdit.getServerContextRoot();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (webEdit != null) {
                        webEdit.dispose();
                    }
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    if (webEdit == null) break block8;
                }
                webEdit.dispose();
            }
            if (this.contextRoot == null) {
                this.contextRoot = this.getProject().getName();
            }
        }
        return this.contextRoot;
    }

    public IContainer getCSSFolder() {
        return this.getProject().getFolder(this.getBasicWebModulePath().append("theme"));
    }

    public IJavaProject getJ2EEJavaProject() {
        return JemProjectUtilities.getJavaProject((IProject)this.project);
    }

    protected IPath getLibraryPath() {
        return this.getWEBINFPath().append("lib");
    }

    public IContainer getLibraryFolder() {
        return this.getProject().getFolder(this.getLibraryPath());
    }

    protected String getMetaPathKey() {
        return "WEB-INF";
    }

    public IContainer getModuleServerRoot() {
        return this.getProject().getFolder(this.getModuleServerRootName());
    }

    public String getModuleServerRootName() {
        return "";
    }

    public void setModuleServerRootName(String name) throws CoreException {
    }

    public IContainer getEMFRoot() {
        return this.getModuleServerRoot();
    }

    public String getNatureID() {
        return "org.eclipse.jst.j2ee.web.WebNature";
    }

    protected String getPluginID() {
        return "com.ibm.etools.webtools";
    }

    public RelationData getRelationData() {
        if (this.relationData == null) {
            this.relationData = new RelationData();
            this.relationData.restore(this.getProject());
        }
        return this.relationData;
    }

    public IContainer getRootPublishableFolder() {
        return this.getModuleServerRoot();
    }

    public static J2EEWebNatureRuntime getRuntime(IProject project) {
        try {
            J2EEWebNatureRuntime a = (J2EEWebNatureRuntime)project.getNature("org.eclipse.jst.j2ee.web.WebNature");
            return a;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public ITaglibRegistry getTaglibRegistry() {
        return WebPlugin.getDefault().getTaglibRegistryManager().getTaglibRegistry(this.getProject());
    }

    public String getEditModelKey() {
        return "org.eclipse.jst.web.editModel";
    }

    public WebEditModel getWebAppEditModelForRead(Object accessorKey) {
        return (WebEditModel)this.getEditModelForRead("org.eclipse.jst.web.editModel", accessorKey);
    }

    public WebEditModel getWebAppEditModelForWrite(Object accessorKey) {
        return (WebEditModel)this.getEditModelForWrite("org.eclipse.jst.web.editModel", accessorKey);
    }

    public IPath getWEBINFPath() {
        return this.getBasicWebModulePath().append("WEB-INF");
    }

    public IPath getDeploymentDescriptorPath() {
        return this.getWEBINFPath().append("web.xml");
    }

    public IPath getWebBindingsPath() {
        if (this.getWebNatureType() == 1) {
            return this.getProjectPath().append(this.getWEBINFPath()).append("ibm-web-bnd.xmi");
        }
        return null;
    }

    public IPath getWebExtensionsPath() {
        if (this.getWebNatureType() == 1) {
            return this.getProjectPath().append(this.getWEBINFPath()).append("ibm-web-ext.xmi");
        }
        return null;
    }

    public IPath getBasicWebModulePath() {
        return new Path("");
    }

    public IPath getWebModulePath() {
        return this.getProjectPath().append(this.getBasicWebModulePath());
    }

    public int getWebNatureType() {
        if (this.fWebNatureType == -1) {
            IContainer webmoduleFolder;
            IFolder webinfFolder;
            String strType = PROJECTTYPE_J2EE_VALUE;
            if (strType != null && strType.equalsIgnoreCase(PROJECTTYPE_J2EE_VALUE)) {
                this.fWebNatureType = 1;
            }
            if (this.fWebNatureType == -1 && (webinfFolder = ((IFolder)(webmoduleFolder = this.getRootPublishableFolder())).getFolder("WEB-INF")).exists()) {
                this.fWebNatureType = 1;
            }
        }
        return this.fWebNatureType;
    }

    public static int getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public int getVersion() {
        if (this.fVersion == -1) {
            try {
                String versionString = "22";
                if (versionString != null) {
                    this.fVersion = Integer.parseInt(versionString);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.fVersion;
    }

    public void setVersion(String newVersion) throws CoreException {
        this.fVersion = -1;
    }

    public IPath getWebSettingsPath() {
        return this.getProjectPath().append(".j2ee");
    }

    protected XMLResource getWebXmiResource() {
        Resource res = this.getResource(URI.createURI((String)"WEB-INF/web.xml"));
        return (XMLResource)res;
    }

    public IPath getWebXMLPath() {
        if (this.getWebNatureType() == 1) {
            return this.getProjectPath().append(this.getWEBINFPath()).append("web.xml");
        }
        return null;
    }

    public static boolean hasRuntime(IProject project) {
        try {
            return project.hasNature("org.eclipse.jst.j2ee.web.WebNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void initializeFromInfo(WebProjectInfo info) throws CoreException {
        int natureType;
        this.fWebNatureType = natureType = info.getWebProjectType();
        super.initializeFromInfo((IJavaProjectInfo)info);
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            IProjectDescription desc = this.getProject().getDescription();
            desc.setBuildSpec(newCommands);
            this.getProject().setDescription(desc, null);
        }
    }

    public void removeFeatureId(String featureId) throws CoreException {
    }

    public void setContextRoot(String newContextRoot) throws CoreException {
        this.contextRoot = newContextRoot;
    }

    public void primaryContributeToContext(EMFWorkbenchContextBase aNewEMFContext) {
        if (this.emfContext == aNewEMFContext) {
            return;
        }
        ModuleCoreNature moduleCoreNature = ModuleCoreNature.getModuleCoreNature((IProject)this.getProject());
        if (moduleCoreNature == null) {
            this.setupNonFlexibleProject(aNewEMFContext);
        } else {
            this.setupFlexibleProject(aNewEMFContext);
        }
    }

    private void setupFlexibleProject(EMFWorkbenchContextBase aNewEMFContext) {
        this.emfContext = aNewEMFContext;
        this.getEmfContext().setDefaultToMOF5Compatibility(true);
        ProjectResourceSet projectResourceSet = aNewEMFContext.getResourceSet();
        projectResourceSet.setURIConverter(this.createURIConverter(this.getProject(), projectResourceSet));
        this.initializeCacheEditModel();
        this.addAdapterFactories((ResourceSet)projectResourceSet);
        projectResourceSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
    }

    private URIConverter createURIConverter(IProject aProject, ProjectResourceSet aResourceSet) {
        return new ComponentCoreURIConverter(aProject, aResourceSet.getSynchronizer());
    }

    private void setupNonFlexibleProject(EMFWorkbenchContextBase aNewEMFContext) {
        super.primaryContributeToContext(aNewEMFContext);
        WorkbenchURIConverter converter = (WorkbenchURIConverter)aNewEMFContext.getResourceSet().getURIConverter();
        converter.addInputContainer((IContainer)this.getProject());
    }

    protected String convertNatureTypeToString(int type) {
        return PROJECTTYPE_J2EE_VALUE;
    }

    public void setWebNatureType(int natureType) throws CoreException {
        this.fWebNatureType = natureType;
    }

    public boolean isJSP1_2() {
        return this.getJSPLevel().equals(JSPLEVEL_1_2);
    }

    public boolean isServlet2_3() {
        return SERVLETLEVEL_2_3.equals(this.getServletLevel());
    }

    public String getJSPLevel() {
        if (this.jspLevel == null) {
            switch (this.getModuleVersion()) {
                case 22: {
                    this.jspLevel = "JSP 1.1";
                    break;
                }
                case 23: {
                    this.jspLevel = JSPLEVEL_1_2;
                    break;
                }
                case 24: {
                    this.jspLevel = JSPLEVEL_2_0;
                    break;
                }
                default: {
                    this.jspLevel = "JSP 1.1";
                }
            }
        }
        return this.jspLevel;
    }

    public WebApp getWebApp() {
        return ((WebEditModel)this.getCacheEditModel()).getWebApp();
    }

    public String getServletLevel() {
        WebEditModel editModel = (WebEditModel)this.getCacheEditModel();
        String retVal = "Servlet 2.2";
        if (editModel != null) {
            WebAppResource resource = editModel.getWebXmiResource();
            WebApp app = resource.getWebApp();
            switch (app.getVersionID()) {
                case 24: {
                    retVal = SERVLETLEVEL_2_4;
                    break;
                }
                case 23: {
                    retVal = SERVLETLEVEL_2_3;
                    break;
                }
                default: {
                    retVal = "Servlet 2.2";
                }
            }
        }
        return retVal;
    }

    public void setJSPLevel(String level) throws CoreException {
        if (this.jspLevel != null && this.jspLevel.equals(level)) {
            return;
        }
        String tJspLevel = null;
        if ("JSP 1.1".equals(level)) {
            tJspLevel = "JSP 1.1";
        } else if (JSPLEVEL_1_2.equals(level)) {
            tJspLevel = JSPLEVEL_1_2;
        } else if (JSPLEVEL_2_0.equals(level)) {
            tJspLevel = JSPLEVEL_2_0;
        }
        this.jspLevel = tJspLevel;
    }

    /*
     * Exception decompiling
     */
    public void setServletLevel(String servletLevel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 137->141)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ILibModule[] getLibModules() {
        if (this.libModules == null && this.libModules == null) {
            this.libModules = new ILibModule[0];
        }
        return this.libModules;
    }

    public void setLibModules(ILibModule[] libModules) throws CoreException {
        this.libModules = libModules;
    }

    public String[] getFeatureIds() {
        if (this.featureIds == null) {
            this.featureIds = new String[0];
        }
        return this.featureIds;
    }

    public void setFeatureIds(String[] featureIds) throws CoreException {
    }

    public boolean isJ2EE1_3() {
        return this.getJ2EEVersion() == 13;
    }

    public boolean isJ2EE() {
        return true;
    }

    public boolean isStatic() {
        return false;
    }

    public String getOverlayIconName() {
        switch (this.getJ2EEVersion()) {
            case 12: {
                return WEB_PROJECT_12_OVERLAY;
            }
            case 13: {
                return WEB_PROJECT_13_OVERLAY;
            }
        }
        return WEB_PROJECT_14_OVERLAY;
    }

    public int getDeploymentDescriptorType() {
        return 4;
    }

    public EObject getDeploymentDescriptorRoot() {
        return this.getWebApp();
    }

    protected int getVersionFromModuleFile() {
        WebApp ddRoot = this.getWebApp();
        if (ddRoot != null) {
            return ddRoot.getVersionID();
        }
        return 24;
    }

    public J2EEEditModel getJ2EEEditModelForRead(Object accessorKey) {
        return this.getWebAppEditModelForRead(accessorKey);
    }

    public J2EEEditModel getJ2EEEditModelForWrite(Object accessorKey) {
        return this.getWebAppEditModelForWrite(accessorKey);
    }
}

