/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModel;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassOperation;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperation;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModel;

public class AddServletOperation
extends ArtifactEditOperation {
    public AddServletOperation(NewServletClassDataModel dataModel) {
        super((ArtifactEditOperationDataModel)dataModel);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        NewServletClassDataModel model = (NewServletClassDataModel)this.operationDataModel;
        boolean isServletType = model.getBooleanProperty("NewServletClassDataModel.IS_SERVLET_TYPE");
        String qualifiedClassName = model.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        if (isServletType) {
            qualifiedClassName = this.createServletClass();
        }
        if (!model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            this.generateServletMetaData(model, qualifiedClassName, isServletType);
        }
    }

    protected String createServletClass() {
        NewServletClassDataModel model = (NewServletClassDataModel)this.operationDataModel;
        NewServletClassOperation op = new NewServletClassOperation((ArtifactEditOperationDataModel)model);
        try {
            op.run(null);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger().log((Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return model.getQualifiedClassName();
    }

    protected void generateServletMetaData(NewServletClassDataModel model, String qualifiedClassName, boolean isServletType) {
        List urlMappingList;
        Servlet servlet = this.createServlet(qualifiedClassName, isServletType);
        List initParamList = (List)model.getProperty("NewServletClassDataModel.INIT_PARAM");
        if (initParamList != null) {
            this.setUpInitParams(initParamList, servlet);
        }
        if ((urlMappingList = (List)model.getProperty("NewServletClassDataModel.URL_MAPPINGS")) != null) {
            this.setUpURLMappings(urlMappingList, servlet);
        }
    }

    private Servlet createServlet(String qualifiedClassName, boolean isServletType) {
        NewServletClassDataModel model = (NewServletClassDataModel)this.operationDataModel;
        String displayName = model.getStringProperty("NewServletClassDataModel.DISPLAY_NAME");
        String description = model.getStringProperty("NewServletClassDataModel.DESCRIPTION");
        Servlet servlet = WebapplicationFactory.eINSTANCE.createServlet();
        servlet.setDisplayName(displayName);
        servlet.setServletName(displayName);
        servlet.setDescription(description);
        if (isServletType) {
            ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
            servletType.setClassName(qualifiedClassName);
            servlet.setWebType((WebType)servletType);
        } else {
            JSPType jspType = WebapplicationFactory.eINSTANCE.createJSPType();
            jspType.setJspFile(qualifiedClassName);
            servlet.setWebType((WebType)jspType);
        }
        WebApp webApp = (WebApp)this.getArtifactEdit().getContentModelRoot();
        webApp.getServlets().add((Object)servlet);
        return servlet;
    }

    private void setUpInitParams(List initParamList, Servlet servlet) {
        WebApp webApp = (WebApp)this.getArtifactEdit().getContentModelRoot();
        int nP = initParamList.size();
        if (webApp.getJ2EEVersionID() >= 14) {
            int iP = 0;
            while (iP < nP) {
                String[] stringArray = (String[])initParamList.get(iP);
                ParamValue param = CommonFactory.eINSTANCE.createParamValue();
                param.setName(stringArray[0]);
                param.setValue(stringArray[1]);
                Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(stringArray[2]);
                param.getDescriptions().add((Object)descriptionObj);
                param.setDescription(stringArray[2]);
                servlet.getInitParams().add((Object)param);
                ++iP;
            }
        } else {
            int iP = 0;
            while (iP < nP) {
                String[] stringArray = (String[])initParamList.get(iP);
                InitParam ip = WebapplicationFactory.eINSTANCE.createInitParam();
                ip.setParamName(stringArray[0]);
                ip.setParamValue(stringArray[1]);
                ip.setDescription(stringArray[2]);
                servlet.getParams().add((Object)ip);
                ++iP;
            }
        }
    }

    private void setUpURLMappings(List urlMappingList, Servlet servlet) {
        WebApp webApp = (WebApp)this.getArtifactEdit().getContentModelRoot();
        int nM = urlMappingList.size();
        int iM = 0;
        while (iM < nM) {
            String[] stringArray = (String[])urlMappingList.get(iM);
            ServletMapping mapping = WebapplicationFactory.eINSTANCE.createServletMapping();
            mapping.setServlet(servlet);
            mapping.setName(servlet.getServletName());
            mapping.setUrlPattern(stringArray[0]);
            webApp.getServletMappings().add((Object)mapping);
            ++iM;
        }
    }
}

