/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.archive.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEComponentCreationOperation;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.web.classpath.WebAppContainer;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.web.datamodel.properties.IWebComponentCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.Property;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class WebComponentCreationOperation
extends J2EEComponentCreationOperation
implements IWebComponentCreationDataModelProperties {
    public WebComponentCreationOperation(IDataModel model) {
        super(model);
    }

    protected void createAndLinkJ2EEComponentsForMultipleComponents() throws CoreException {
        this.createWebStructure("/" + this.getModuleName());
    }

    protected void createAndLinkJ2EEComponentsForSingleComponent() throws CoreException {
        this.createWebStructure("");
    }

    protected void createWebStructure(String prefix) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject(), (String)this.getModuleDeployName());
        component.create(0, null);
        IVirtualFolder javaSourceFolder = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF/classes"));
        javaSourceFolder.createLink((IPath)new Path(this.model.getStringProperty("IJavaComponentCreationDataModelProperties.JAVASOURCE_FOLDER")), 0, null);
        IVirtualFolder webContent = component.getRootFolder().getFolder((IPath)new Path("/"));
        webContent.createLink((IPath)new Path(String.valueOf(prefix) + "/WebContent"), 0, null);
        IVirtualFolder webInfFolder = webContent.getFolder("WEB-INF");
        webInfFolder.create(1, null);
        IVirtualFolder metaInfFolder = webContent.getFolder("META-INF");
        metaInfFolder.create(1, null);
        IVirtualFolder webLib = webInfFolder.getFolder("lib");
        webLib.create(1, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createDeploymentDescriptor(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        WebArtifactEdit webEdit = null;
        try {
            try {
                ComponentHandle handle = ComponentHandle.create((IProject)this.getProject(), (String)this.model.getStringProperty("IComponentCreationDataModelProperties.COMPONENT_DEPLOY_NAME"));
                webEdit = WebArtifactEdit.getWebArtifactEditForWrite(handle);
                Integer version = (Integer)this.model.getProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION");
                webEdit.createModelRoot(version);
                webEdit.save(monitor);
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (webEdit != null) {
                webEdit.dispose();
            }
            webEdit = null;
            throw throwable;
        }
        {
            Object var5_8 = null;
            if (webEdit == null) return;
        }
        webEdit.dispose();
    }

    protected String getVersion() {
        int version = this.model.getIntProperty("IComponentCreationDataModelProperties.COMPONENT_VERSION");
        return J2EEVersionUtil.getServletTextVersion((int)version);
    }

    protected List getProperties() {
        ArrayList<Property> newProps = new ArrayList<Property>();
        Property prop = ComponentcoreFactory.eINSTANCE.createProperty();
        prop.setName("context-root");
        prop.setValue(this.model.getStringProperty("IAddWebComponentToEnterpriseApplicationDataModelProperties.CONTEXT_ROOT"));
        newProps.add(prop);
        return newProps;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            super.execute("jst.web", monitor);
            IJavaProject jproject = JemProjectUtilities.getJavaProject((IProject)this.getProject());
            ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] old = jproject.getRawClasspath();
            int i = 0;
            while (i < old.length) {
                cp.add(old[i]);
                ++i;
            }
            String name = this.getModuleDeployName();
            cp.add(WebAppContainer.convert(name));
            IClasspathEntry[] cparray = new IClasspathEntry[cp.size()];
            cp.toArray(cparray);
            jproject.setRawClasspath(cparray, null);
        }
        catch (CoreException e) {
            Logger.getLogger().log((Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            Logger.getLogger().log((Object)e.getMessage());
        }
        catch (InterruptedException e) {
            Logger.getLogger().log((Object)e.getMessage());
        }
        return OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

