/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.ui.internal.properties.EnumeratedStringPropertyDescriptor;
import org.eclipse.wst.xml.ui.internal.tabletree.DOMPropertyDescriptorFactory;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLTableTreePropertyDescriptorFactory
extends DOMPropertyDescriptorFactory {
    protected TreeContentHelper treeContentHelper = new TreeContentHelper();

    public XMLTableTreePropertyDescriptorFactory(ModelQuery modelQuery) {
        super(modelQuery);
    }

    protected IPropertyDescriptor createPropertyDescriptorHelper(String name, Element element, CMNode cmNode) {
        EnumeratedStringPropertyDescriptor result = null;
        String[] valuesArray = this.getModelQuery().getPossibleDataTypeValues(element, cmNode);
        if (valuesArray != null && valuesArray.length > 0) {
            result = new EnumeratedStringPropertyDescriptor(name, name, valuesArray);
        }
        return result;
    }

    public IPropertyDescriptor createTextPropertyDescriptor(Text text) {
        TextPropertyDescriptor result = null;
        Node parentNode = text.getParentNode();
        if (parentNode != null && parentNode.getNodeType() == 1) {
            Element parentElement = (Element)parentNode;
            CMElementDeclaration ed = this.getModelQuery().getCMElementDeclaration(parentElement);
            if (ed != null) {
                result = this.createPropertyDescriptorHelper("hack", parentElement, (CMNode)ed);
            }
        }
        if (result == null) {
            result = new TextPropertyDescriptor((Object)"hack", "hack");
        }
        return result;
    }

    public IPropertyDescriptor createAttributePropertyDescriptor(Attr attr) {
        IPropertyDescriptor result = null;
        String attributeName = attr.getName();
        CMAttributeDeclaration ad = this.getModelQuery().getCMAttributeDeclaration(attr);
        if (ad != null) {
            result = this.createPropertyDescriptorHelper(attributeName, attr.getOwnerElement(), (CMNode)ad);
        }
        if (result == null) {
            result = new TextPropertyDescriptor((Object)attributeName, attributeName);
        }
        return result;
    }

    public IPropertyDescriptor createElementPropertyDescriptor(Element element) {
        Text text;
        TextPropertyDescriptor result = null;
        List list = this.treeContentHelper.getElementTextContent(element);
        if (list != null && (text = this.treeContentHelper.getEffectiveTextNodeForCombinedNodeList(list)) != null) {
            result = this.createTextPropertyDescriptor(text);
        }
        if (result == null) {
            result = new TextPropertyDescriptor((Object)"hack", "hack");
        }
        return result;
    }
}

