/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManagerListener;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreePropertyDescriptorFactory;
import org.eclipse.wst.xml.ui.internal.util.SharedXMLEditorPluginImageHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLTableTreeContentProvider
implements ITreeContentProvider,
ITableLabelProvider,
ILabelProvider,
CMDocumentManagerListener {
    protected ViewerNotifyingAdapterFactory viewerNotifyingAdapterFactory = new ViewerNotifyingAdapterFactory();
    protected XMLTableTreePropertyDescriptorFactory propertyDescriptorFactory;
    protected List viewerList = new Vector();
    protected TreeContentHelper treeContentHelper = new TreeContentHelper();
    protected CMDocumentManager documentManager;

    public void getDecendantList(Object element, List list) {
        Object[] children = this.getChildren(element);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                list.add(child);
                this.getDecendantList(child, list);
                ++i;
            }
        }
    }

    public void addViewer(Viewer viewer) {
        this.viewerList.add(viewer);
    }

    public Object[] getChildren(Object element) {
        this.viewerNotifyingAdapterFactory.doAdapt(element);
        return this.treeContentHelper.getChildren(element);
    }

    public Object getParent(Object o) {
        Node result = null;
        if (o instanceof Node) {
            Node node = (Node)o;
            result = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        this.viewerNotifyingAdapterFactory.doAdapt(element);
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object element) {
        this.viewerNotifyingAdapterFactory.doAdapt(element);
        return this.getChildren(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ModelQuery mq;
        Document domDoc;
        if (oldInput != null) {
            this.propertyDescriptorFactory = null;
            domDoc = (Document)oldInput;
            mq = ModelQueryUtil.getModelQuery((Document)domDoc);
            if (mq != null) {
                this.documentManager = mq.getCMDocumentManager();
                if (this.documentManager != null) {
                    this.documentManager.removeListener((CMDocumentManagerListener)this);
                }
            }
        }
        if (newInput != null && (mq = ModelQueryUtil.getModelQuery((Document)(domDoc = (Document)newInput))) != null) {
            this.propertyDescriptorFactory = new XMLTableTreePropertyDescriptorFactory(mq);
            this.documentManager = mq.getCMDocumentManager();
            if (this.documentManager != null) {
                this.documentManager.setPropertyEnabled("asyncLoad", true);
                this.documentManager.addListener((CMDocumentManagerListener)this);
            }
        }
    }

    public boolean isDeleted(Object element) {
        return element != null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.viewerList = new Vector();
    }

    public Element getRootElement(Document document) {
        Element rootElement = null;
        Node childNode = document.getFirstChild();
        while (childNode != null) {
            if (childNode.getNodeType() == 1) {
                rootElement = (Element)childNode;
                break;
            }
            childNode = childNode.getNextSibling();
        }
        return rootElement;
    }

    public Image getImage(Object object) {
        this.viewerNotifyingAdapterFactory.doAdapt(object);
        Image image = null;
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 2: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/attribute_obj.gif");
                    break;
                }
                case 4: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/cdatasection.gif");
                    break;
                }
                case 8: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/comment_obj.gif");
                    break;
                }
                case 10: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/doctype.gif");
                    break;
                }
                case 1: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/element_obj.gif");
                    break;
                }
                case 7: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/proinst_obj.gif");
                    break;
                }
                case 3: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/text.gif");
                    break;
                }
                case 5: {
                    image = SharedXMLEditorPluginImageHelper.getImage("icons/full/obj16/entity_reference.gif");
                }
            }
        }
        return image;
    }

    public String getText(Object object) {
        this.viewerNotifyingAdapterFactory.doAdapt(object);
        String result = null;
        if (object instanceof Node) {
            Node node = (Node)object;
            switch (node.getNodeType()) {
                case 2: {
                    result = node.getNodeName();
                    break;
                }
                case 10: {
                    result = "DOCTYPE";
                    break;
                }
                case 1: {
                    result = node.getNodeName();
                    break;
                }
                case 7: {
                    result = ((ProcessingInstruction)node).getTarget();
                }
            }
        }
        return result != null ? result : "";
    }

    public String getColumnText(Object object, int column) {
        this.viewerNotifyingAdapterFactory.doAdapt(object);
        String result = null;
        if (column == 0) {
            result = this.getText(object);
        } else if (column == 1 && object instanceof Node) {
            result = this.treeContentHelper.getNodeValue((Node)object);
        }
        return result != null ? result : "";
    }

    public Image getColumnImage(Object object, int columnIndex) {
        this.viewerNotifyingAdapterFactory.doAdapt(object);
        return columnIndex == 0 ? this.getImage(object) : null;
    }

    public boolean isLabelProperty(Object object, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isIgnorableText(Node node) {
        boolean result = false;
        try {
            if (node.getNodeType() == 3) {
                String data = ((Text)node).getData();
                result = data == null || data.trim().length() == 0;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return result;
    }

    public static Text getHiddenChildTextNode(Node node) {
        return null;
    }

    public void cacheCleared(CMDocumentCache cache) {
        this.doDelayedRefreshForViewers();
    }

    public void cacheUpdated(CMDocumentCache cache, String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
        if (newStatus == 3 || newStatus == 4) {
            this.doDelayedRefreshForViewers();
        }
    }

    public void propertyChanged(CMDocumentManager cmDocumentManager, String propertyName) {
        if (cmDocumentManager.getPropertyEnabled("autoLoad")) {
            this.doDelayedRefreshForViewers();
        }
    }

    protected void doDelayedRefreshForViewers() {
        Vector list = new Vector();
        list.addAll(this.viewerList);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            final Viewer viewer = (Viewer)i.next();
            Control control = viewer.getControl();
            Runnable runnable = new Runnable(){

                public void run() {
                    viewer.refresh();
                }
            };
            control.getDisplay().asyncExec(runnable);
        }
    }

    public class ViewerNotifyingAdapterFactory
    extends AbstractAdapterFactory {
        protected ViewerNotifyingAdapter viewerNotifyingAdapter;

        public ViewerNotifyingAdapterFactory() {
            this.viewerNotifyingAdapter = new ViewerNotifyingAdapter();
        }

        protected INodeAdapter createAdapter(INodeNotifier target) {
            return this.viewerNotifyingAdapter;
        }

        protected ViewerNotifyingAdapter doAdapt(Object object) {
            ViewerNotifyingAdapter result = null;
            if (object instanceof INodeNotifier) {
                result = (ViewerNotifyingAdapter)this.adapt((INodeNotifier)object);
            }
            return result;
        }
    }

    public class ViewerNotifyingAdapter
    implements INodeAdapter {
        public boolean isAdapterForType(Object type) {
            return type.equals((Object)XMLTableTreeContentProvider.this.viewerNotifyingAdapterFactory);
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            switch (eventType) {
                case 1: 
                case 4: 
                case 5: {
                    Node node = (Node)notifier;
                    if (node.getNodeType() != 1 && node.getNodeType() != 9) break;
                    Iterator i = XMLTableTreeContentProvider.this.viewerList.iterator();
                    while (i.hasNext()) {
                        Viewer viewer = (Viewer)i.next();
                        if (viewer instanceof StructuredViewer) {
                            ((StructuredViewer)viewer).refresh((Object)node);
                            continue;
                        }
                        viewer.refresh();
                    }
                    break;
                }
            }
        }
    }
}

