/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.util.StringUtils;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapterFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManagerListener;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentoutline.BufferedOutlineUpdater;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.eclipse.wst.xml.ui.internal.contentoutline.RefreshPropertySheetJob;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JFaceNodeAdapter
implements IJFaceNodeAdapter {
    static final Class ADAPTER_KEY;
    private static final boolean DEBUG;
    INodeAdapterFactory fAdapterFactory;
    private CMDocumentManagerListener cmDocumentManagerListener;
    private BufferedOutlineUpdater fUpdater = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_KEY = clazz;
        DEBUG = JFaceNodeAdapter.getDebugValue();
    }

    private static boolean getDebugValue() {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/outline");
        boolean result = value != null && value.equalsIgnoreCase("true");
        return result;
    }

    public JFaceNodeAdapter(INodeAdapterFactory adapterFactory1) {
        this.fAdapterFactory = adapterFactory1;
    }

    protected Image createImage(Object object) {
        Image image = null;
        Node node = (Node)object;
        switch (node.getNodeType()) {
            case 1: {
                image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
                break;
            }
            case 2: {
                image = this.createXMLImageDescriptor("icons/full/obj16/attribute_obj.gif");
                break;
            }
            case 3: {
                image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
                break;
            }
            case 4: {
                image = this.createXMLImageDescriptor("icons/full/obj16/cdatasection.gif");
                break;
            }
            case 5: 
            case 6: {
                image = this.createXMLImageDescriptor("icons/full/obj16/entity.gif");
                break;
            }
            case 7: {
                image = this.createXMLImageDescriptor("icons/full/obj16/proinst_obj.gif");
                break;
            }
            case 8: {
                image = this.createXMLImageDescriptor("icons/full/obj16/comment_obj.gif");
                break;
            }
            case 10: {
                image = this.createXMLImageDescriptor("icons/full/obj16/doctype.gif");
                break;
            }
            case 12: {
                image = this.createXMLImageDescriptor("icons/full/obj16/notation.gif");
                break;
            }
            default: {
                image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
            }
        }
        return image;
    }

    protected Image createXMLImageDescriptor(String imageResourceName) {
        return XMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
    }

    public Object[] getChildren(Object object) {
        Node node = (Node)object;
        ArrayList<Node> v = new ArrayList<Node>(node.getChildNodes().getLength());
        Node child = node.getFirstChild();
        while (child != null) {
            Node n = child;
            if (n.getNodeType() != 3) {
                v.add(n);
            }
            child = child.getNextSibling();
        }
        return v.toArray();
    }

    public CMDocumentManagerListener getCMDocumentManagerListener() {
        if (this.cmDocumentManagerListener == null) {
            this.cmDocumentManagerListener = new CMDocumentManagerListenerImpl();
        }
        return this.cmDocumentManagerListener;
    }

    Display getDisplay() {
        Display display = null;
        if (PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        return display;
    }

    public Object[] getElements(Object node) {
        return this.getChildren(node);
    }

    public Image getLabelImage(Object node) {
        String nodeName;
        ImageRegistry imageRegistry;
        Image image = CMImageUtil.getImage(CMImageUtil.getDeclaration((Node)node));
        if (image == null && JFaceResources.getImageRegistry() != null && (image = (imageRegistry = JFaceResources.getImageRegistry()).get(nodeName = this.getNodeName(node))) == null && (image = this.createImage(node)) != null) {
            imageRegistry.put(nodeName, image);
        }
        return image;
    }

    public String getLabelText(Object node) {
        return this.getNodeName(node);
    }

    private String getNodeName(Object object) {
        StringBuffer nodeName = new StringBuffer();
        Node node = (Node)object;
        nodeName.append(node.getNodeName());
        if (node.getNodeType() == 10) {
            nodeName.insert(0, "DOCTYPE:");
        } else if (node.getNodeType() == 1 && this.getShowAttribute() && node.hasAttributes()) {
            String attributeName;
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            Node attribute = null;
            Node attribute2 = null;
            CMElementDeclaration elementDecl = null;
            ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
            if (mq != null) {
                elementDecl = mq.getCMElementDeclaration(element);
            }
            if (elementDecl != null) {
                int i = 0;
                while (i < attributes.getLength() && attribute == null) {
                    Node attr = attributes.item(i);
                    String attrName = attr.getNodeName();
                    CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)elementDecl.getAttributes().getNamedItem(attrName);
                    if (attrDecl != null) {
                        if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                            attribute = attr;
                        } else if (attrDecl.getUsage() == 2) {
                            attribute2 = attr;
                        }
                    }
                    ++i;
                }
            }
            if (attribute == null) {
                attribute = attribute2 != null ? attribute2 : attributes.item(0);
            }
            if ((attributeName = attribute.getNodeName()) != null && attributeName.length() > 0) {
                nodeName.append(" " + attributeName);
                String attributeValue = attribute.getNodeValue();
                if (attributeValue != null && attributeValue.length() > 0) {
                    nodeName.append("=" + StringUtils.strip((String)attributeValue));
                }
            }
        }
        return nodeName.toString();
    }

    private BufferedOutlineUpdater getOutlineUpdater() {
        if (this.fUpdater == null) {
            this.fUpdater = new BufferedOutlineUpdater();
        }
        return this.fUpdater;
    }

    public Object getParent(Object object) {
        Node node = (Node)object;
        return node.getParentNode();
    }

    public boolean hasChildren(Object object) {
        Node node = (Node)object;
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    public boolean isAdapterForType(Object type) {
        if (type == null) {
            return false;
        }
        return type.equals(ADAPTER_KEY);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Collection listeners = ((JFaceNodeAdapterFactory)this.fAdapterFactory).getListeners();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            PropertySheetPage propertySheetPage;
            Object listener = iterator.next();
            if (notifier instanceof Node && listener instanceof StructuredViewer && (eventType == 4 || eventType == 1)) {
                StructuredViewer structuredViewer;
                if (DEBUG) {
                    System.out.println("JFaceNodeAdapter notified on event type > " + eventType);
                }
                if ((structuredViewer = (StructuredViewer)listener).getControl() == null) continue;
                this.getOutlineUpdater().processNode(structuredViewer, (Node)notifier);
                continue;
            }
            if (!(listener instanceof PropertySheetPage) || eventType != 1 && eventType != 4 || (propertySheetPage = (PropertySheetPage)listener).getControl() == null) continue;
            RefreshPropertySheetJob refreshPropertySheetJob = new RefreshPropertySheetJob(this.getDisplay(), XMLUIMessages.JFaceNodeAdapter_1, propertySheetPage);
            refreshPropertySheetJob.schedule();
        }
    }

    private boolean getShowAttribute() {
        return ((JFaceNodeAdapterFactory)this.fAdapterFactory).getShowAttribute();
    }

    public class CMDocumentManagerListenerImpl
    implements CMDocumentManagerListener {
        List beingRefreshed = Collections.synchronizedList(new ArrayList());

        public void cacheCleared(CMDocumentCache cache) {
        }

        public void cacheUpdated(CMDocumentCache cache, String uri, int oldStatus, int newStatus, CMDocument cmDocument) {
            if (newStatus == 3 || newStatus == 4) {
                this.refreshViewers();
            }
        }

        Display getDisplay() {
            Display display = null;
            if (PlatformUI.isWorkbenchRunning()) {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            return display;
        }

        public void propertyChanged(CMDocumentManager cmDocumentManager, String propertyName) {
            if (cmDocumentManager.getPropertyEnabled("autoLoad")) {
                this.refreshViewers();
            }
        }

        private void refreshViewers() {
            Collection listeners = ((IJFaceNodeAdapterFactory)JFaceNodeAdapter.this.fAdapterFactory).getListeners();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                Object listener = iterator.next();
                if (!(listener instanceof PropertySheetPage) || this.beingRefreshed.contains(listener)) continue;
                PropertySheetPage propertySheetPage = (PropertySheetPage)listener;
                this.beingRefreshed.add(propertySheetPage);
                this.getDisplay().asyncExec(new Runnable(this, propertySheetPage){
                    final /* synthetic */ CMDocumentManagerListenerImpl this$1;
                    private final /* synthetic */ PropertySheetPage val$propertySheetPage;
                    {
                        this.this$1 = cMDocumentManagerListenerImpl;
                        this.val$propertySheetPage = propertySheetPage;
                    }

                    public void run() {
                        if (this.this$1.getDisplay().isDisposed()) {
                            return;
                        }
                        if (this.val$propertySheetPage.getControl() != null && !this.val$propertySheetPage.getControl().isDisposed()) {
                            this.val$propertySheetPage.refresh();
                            this.this$1.beingRefreshed.remove(this.val$propertySheetPage);
                        }
                    }
                });
            }
        }
    }
}

