/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.WSIConstants;
import org.eclipse.wst.wsi.internal.core.common.AddStyleSheet;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Element;

public final class TestUtils {
    public static final void parseAddStyleSheet(Element element, AddStyleSheet addStyleSheet, String defaultHref) {
        addStyleSheet.setHref(XMLUtils.getAttributeValue(element, "href", defaultHref));
        addStyleSheet.setType(XMLUtils.getAttributeValue(element, "type", "text/xsl"));
        addStyleSheet.setTitle(XMLUtils.getAttributeValue(element, "title"));
        addStyleSheet.setMedia(XMLUtils.getAttributeValue(element, "media"));
        addStyleSheet.setCharset(XMLUtils.getAttributeValue(element, "charset"));
        addStyleSheet.setAlternate(XMLUtils.getAttributeValue(element, "alternate"));
    }

    public static void printToolInfo(ToolInfo toolInfo) {
        System.out.println("Conformance " + toolInfo.getName() + " Tool" + ", Version: " + toolInfo.getVersion() + ", Release Date: " + toolInfo.getReleaseDate());
        System.out.println("Copyright (C) 2002-2003 by The Web Services-Interoperability Organization and Certain of its Members. All Rights Reserved.\nUse of this Material is governed by WS-I licenses included within the documentation.");
        System.out.println(" ");
    }

    public static String getXMLComment() {
        String comment = null;
        String readLine = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Utils.getInputStream("comments.xml")));
            comment = "";
            while (bufferedReader.ready()) {
                readLine = bufferedReader.readLine();
                if (readLine == null) continue;
                comment = String.valueOf(comment) + readLine + WSIConstants.LINE_SEPARATOR;
            }
        }
        catch (Exception exception) {}
        return comment;
    }

    public static String getXMLSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.xmlschema.schema", "http://www.w3.org/2001/XMLSchema.xsd");
    }

    public static String getSOAPSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.soap.schema", "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public static String getWSDLSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.wsdl.schema", "http://schemas.xmlsoap.org/wsdl/");
    }

    public static String getWSDLSOAPSchemaLocation() {
        return TestUtils.getSchemaLocation("wsi.analyzer.wsdlsoap.schema", "http://schemas.xmlsoap.org/wsdl/soap/");
    }

    private static String getSchemaLocation(String propertyName, String defaultValue) {
        return defaultValue;
    }
}

