/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.WSIException;

public final class MIMEUtils {
    public static Map getMimeHeaderTokens(String mimeHeaderString, String separators) throws WSIException {
        StringTokenizer tokenizer = new StringTokenizer(mimeHeaderString, "\n\r\f");
        HashMap<String, String> map = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int index = line.indexOf(separators);
            if (index <= 0 || index >= line.length() - 1) continue;
            map.put(line.substring(0, index).toUpperCase(), line.substring(index + 1).trim());
        }
        return map;
    }

    public static String getMimeHeaderSubAttribute(String mimeHeaderString, String attributeName, String subAttributeName) throws WSIException {
        String value = (String)MIMEUtils.getMimeHeaderTokens(mimeHeaderString, ":").get(attributeName.toUpperCase());
        if (value != null) {
            int idxQ = value.toUpperCase().indexOf(String.valueOf(subAttributeName.toUpperCase()) + "=\"");
            int idx = value.toUpperCase().indexOf(String.valueOf(subAttributeName.toUpperCase()) + "=");
            if (idxQ != -1) {
                int eIdxQ = value.indexOf("\"", idxQ += (String.valueOf(subAttributeName) + "=\"").length());
                if (eIdxQ != -1) {
                    return value.substring(idxQ, eIdxQ);
                }
                return null;
            }
            if (idx != -1) {
                int eIdx = -1;
                eIdx = value.indexOf(" ", idx += (String.valueOf(subAttributeName) + "=").length());
                if (eIdx != -1) {
                    return value.substring(idx, eIdx);
                }
                eIdx = value.indexOf(";", idx);
                if (eIdx != -1) {
                    return value.substring(idx, eIdx);
                }
                return value.substring(idx);
            }
            return null;
        }
        return value;
    }

    public static String getMimeHeaderAttribute(String mimeHeaderString, String attributeName) throws WSIException {
        String attributeValue = (String)MIMEUtils.getMimeHeaderTokens(mimeHeaderString, ":").get(attributeName.toUpperCase());
        if (attributeValue != null && attributeValue.indexOf(";") != -1) {
            attributeValue = attributeValue.substring(0, attributeValue.indexOf(";"));
        }
        return attributeValue;
    }
}

