/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.WSIException;

public final class HTTPUtils {
    public static String getURLString(String httpPostHeader) {
        int start;
        String urlString = null;
        if (httpPostHeader.startsWith("POST") || httpPostHeader.startsWith("GET")) {
            start = httpPostHeader.indexOf(32) + 1;
            while (httpPostHeader.charAt(start) == ' ') {
                ++start;
            }
        } else {
            throw new IllegalArgumentException("HTTP header does not contain POST data (was: " + httpPostHeader + ")");
        }
        int end = httpPostHeader.indexOf(32, start);
        urlString = httpPostHeader.substring(start, end);
        return urlString;
    }

    public static Map getHttpHeaderTokens(String httpHeaderString, String separators) throws WSIException {
        StringTokenizer tokenizer = new StringTokenizer(httpHeaderString, "\n\r\f");
        HashMap<String, String> map = new HashMap<String, String>();
        String name = null;
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int index = line.indexOf(separators);
            if (index > 0 && index < line.length() - 1) {
                name = line.substring(0, index).toUpperCase();
                map.put(name, line.substring(index + 1).trim());
                continue;
            }
            if (name == null || line.length() <= 0 || !Character.isWhitespace(line.charAt(0))) continue;
            map.put(name, map.get(name) + " " + line.trim());
        }
        return map;
    }

    public static String getHttpHeaderSubAttribute(String httpHeaderString, String attributeName, String subAttributeName) throws WSIException {
        String value = (String)HTTPUtils.getHttpHeaderTokens(httpHeaderString, ":").get(attributeName.toUpperCase());
        if (value != null) {
            int idxQ = value.toUpperCase().indexOf(String.valueOf(subAttributeName.toUpperCase()) + "=\"");
            int idx = value.toUpperCase().indexOf(String.valueOf(subAttributeName.toUpperCase()) + "=");
            if (idxQ != -1) {
                int eIdxQ = value.indexOf("\"", idxQ += (String.valueOf(subAttributeName) + "=\"").length());
                if (eIdxQ != -1) {
                    return value.substring(idxQ, eIdxQ);
                }
                return null;
            }
            if (idx != -1) {
                int eIdx = -1;
                eIdx = value.indexOf(" ", idx += (String.valueOf(subAttributeName) + "=").length());
                if (eIdx != -1) {
                    return value.substring(idx, eIdx);
                }
                eIdx = value.indexOf(";", idx);
                if (eIdx != -1) {
                    return value.substring(idx, eIdx);
                }
                return value.substring(idx);
            }
            return null;
        }
        return value;
    }

    public static String getHttpHeaderAttribute(String httpHeaderString, String attributeName) throws WSIException {
        String attributeValue = (String)HTTPUtils.getHttpHeaderTokens(httpHeaderString, ":").get(attributeName.toUpperCase());
        if (attributeValue != null && attributeValue.indexOf(";") != -1) {
            attributeValue = attributeValue.substring(0, attributeValue.indexOf(";"));
        }
        return attributeValue;
    }
}

