/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.StringTokenizer;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class BP1002
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1002(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String httpHeader = entryContext.getMessageEntry().getHTTPHeaders();
        if (entryContext.getMessageEntry().getType().equalsIgnoreCase("request")) {
            StringTokenizer postMessage = new StringTokenizer(httpHeader, " \r\n");
            if (postMessage.countTokens() < 3) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(httpHeader, entryContext);
            } else {
                String httpVersion = "";
                String messageType = "";
                int i = 0;
                while (i < 3) {
                    if (i == 0) {
                        messageType = postMessage.nextToken();
                    } else if (i == 2) {
                        httpVersion = postMessage.nextToken();
                    } else {
                        postMessage.nextToken();
                    }
                    ++i;
                }
                if (!messageType.equals("POST")) {
                    this.result = "notApplicable";
                } else if (!httpVersion.equalsIgnoreCase("HTTP/1.1") && !httpVersion.equalsIgnoreCase("HTTP/1.0")) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(httpHeader, entryContext);
                }
            }
        } else {
            StringTokenizer httpMessageTokenizer = new StringTokenizer(httpHeader, "\n\r\f");
            String startLine = null;
            try {
                if (!httpMessageTokenizer.hasMoreTokens()) {
                    throw new AssertionFailException(httpHeader);
                }
                startLine = httpMessageTokenizer.nextToken();
                if (!startLine.startsWith("HTTP/1.1") && !startLine.startsWith("HTTP/1.0")) {
                    throw new AssertionFailException(httpHeader);
                }
            }
            catch (AssertionFailException e) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(e.getMessage(), entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

