/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.text;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class DocumentRegionEdgeMatcher
implements ICharacterPairMatcher {
    public static final String ID = "characterpairmatcher";
    protected int fAnchor;
    protected ICharacterPairMatcher fNextMatcher;
    protected List fRegionTypes;

    public DocumentRegionEdgeMatcher(String[] validContexts, ICharacterPairMatcher nextMatcher) {
        this.fRegionTypes = Arrays.asList(validContexts);
        this.fNextMatcher = nextMatcher;
    }

    public void clear() {
        if (this.fNextMatcher != null) {
            this.fNextMatcher.clear();
        }
    }

    public void dispose() {
        if (this.fNextMatcher != null) {
            this.fNextMatcher.dispose();
        }
    }

    public int getAnchor() {
        if (this.fAnchor < 0 && this.fNextMatcher != null) {
            return this.fNextMatcher.getAnchor();
        }
        return this.fAnchor;
    }

    public IRegion match(IDocument document, int offset) {
        IStructuredDocumentRegion docRegion;
        IRegion match = null;
        if (!this.fRegionTypes.isEmpty() && document instanceof IStructuredDocument && (docRegion = ((IStructuredDocument)document).getRegionAtCharacterOffset(offset)) != null) {
            if (docRegion.getPrevious() != null && docRegion.getPrevious().getEndOffset() == offset && this.fRegionTypes.contains(docRegion.getPrevious().getType())) {
                this.fAnchor = 0;
                match = new Region(docRegion.getPrevious().getStartOffset(), 1);
            } else if (this.fRegionTypes.contains(docRegion.getType()) && docRegion.getStartOffset(docRegion.getLastRegion()) <= offset && offset <= docRegion.getEndOffset(docRegion.getLastRegion())) {
                this.fAnchor = 0;
                match = new Region(docRegion.getStartOffset(), 1);
            } else if (this.fRegionTypes.contains(docRegion.getType()) && docRegion.getStartOffset(docRegion.getFirstRegion()) <= offset && offset <= docRegion.getEndOffset(docRegion.getFirstRegion())) {
                this.fAnchor = 1;
                match = new Region(docRegion.getEndOffset() - 1, 1);
            }
        }
        if (match == null && this.fNextMatcher != null) {
            this.fAnchor = -1;
            match = this.fNextMatcher.match(document, offset);
        }
        return match;
    }
}

