/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import java.util.StringTokenizer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.sse.ui.internal.Logger;

public class ColorHelper {
    public static final String BACKGROUND = "background";
    public static final String BOLD = "bold";
    public static final String FOREGROUND = "foreground";
    public static final String NAME = "name";
    private static final String STYLE_SEPARATOR = "|";

    public static String getColorString(int r, int g, int b) {
        return "#" + ColorHelper.getHexString(r, 2) + ColorHelper.getHexString(g, 2) + ColorHelper.getHexString(b, 2);
    }

    private static String getHexString(int value, int minWidth) {
        String hexString = Integer.toHexString(value);
        int i = hexString.length();
        while (i < minWidth) {
            hexString = "0" + hexString;
            ++i;
        }
        return hexString;
    }

    public static String packStylePreferences(String[] stylePrefs) {
        StringBuffer styleString = new StringBuffer();
        if (stylePrefs.length == 3) {
            int i = 0;
            while (i < 3) {
                String s = stylePrefs[i];
                styleString.append(s);
                if (i != 2) {
                    styleString.append(" | ");
                }
                ++i;
            }
        }
        return styleString.toString();
    }

    public static RGB toRGB(String anRGBString) {
        RGB result = null;
        if (anRGBString.length() > 6 && anRGBString.charAt(0) == '#') {
            int r = 0;
            int g = 0;
            int b = 0;
            try {
                r = Integer.valueOf(anRGBString.substring(1, 3), 16);
                g = Integer.valueOf(anRGBString.substring(3, 5), 16);
                b = Integer.valueOf(anRGBString.substring(5, 7), 16);
                result = new RGB(r, g, b);
            }
            catch (NumberFormatException nfExc) {
                Logger.logException("Could not load highlighting preference for color " + anRGBString, nfExc);
            }
        }
        return result;
    }

    public static String toRGBString(RGB anRGB) {
        if (anRGB == null) {
            return "#000000";
        }
        String red = Integer.toHexString(anRGB.red);
        while (red.length() < 2) {
            red = "0" + red;
        }
        String green = Integer.toHexString(anRGB.green);
        while (green.length() < 2) {
            green = "0" + green;
        }
        String blue = Integer.toHexString(anRGB.blue);
        while (blue.length() < 2) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static String[] unpackStylePreferences(String preference) {
        StringTokenizer st;
        String[] stylePrefs = null;
        if (preference != null && (st = new StringTokenizer(preference, STYLE_SEPARATOR)).countTokens() == 3) {
            String foreground = st.nextToken().trim();
            String background = st.nextToken().trim();
            String bold = st.nextToken().trim();
            stylePrefs = new String[]{foreground, background, bold};
        }
        return stylePrefs;
    }
}

