/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.sse.ui.internal.IDropAction;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.extension.DropActionProxy;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.osgi.framework.Bundle;

public class TransferBuilder
extends RegistryReader {
    public static final String ATT_CLASS = "class";
    public static final String ATT_ID = "id";
    public static final String ATT_METHOD = "method";
    public static final String ATT_PRIORITY = "priority";
    public static final String ATT_SINGLETON = "singleton";
    public static final String ATT_TARGET_ID = "targetID";
    public static final String ATT_TRANSFER_ID = "transferID";
    private static final boolean debugTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/transferbuilder/time"));
    public static final String PL_DRAG_SOURCE_TRANSFERS = "dragSourceTransfers";
    public static final String PL_DROP_TARGET_TRANSFERS = "dropTargetTransfers";
    public static final String PLUGIN_ID = "org.eclipse.wst.sse.ui";
    public static final String[] PRIORITIES = new String[]{"highest", "high", "mid", "low", "lowest"};
    public static final String TAG_DRAG_SOURCE_CONTRIBUTION = "dragSourceContribution";
    public static final String TAG_DROP_ACTION = "dropAction";
    public static final String TAG_DROP_TARGET_CONTRIBUTION = "dropTargetContribution";
    public static final String TAG_TRANSFER = "transfer";
    public static final String TRUE = "true";
    protected List cache;
    protected String targetContributionTag;
    protected List targetIDs;

    static Object createExecutableExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        Object obj = null;
        String singleton = element.getAttribute(ATT_SINGLETON);
        String method = element.getAttribute(ATT_METHOD);
        if (TRUE.equalsIgnoreCase(singleton) && method != null) {
            try {
                String name = element.getAttribute(ATT_CLASS);
                String pluginId = element.getDeclaringExtension().getNamespace();
                Class cls = Platform.getBundle((String)pluginId).loadClass(name);
                Method mtd = cls.getMethod(method, new Class[0]);
                obj = mtd.invoke(null, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                obj = null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                obj = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                obj = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                obj = null;
            }
        } else {
            obj = element.createExecutableExtension(classAttribute);
        }
        return obj;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) {
        final Object[] result = new Object[1];
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle.getState() == 32) {
            try {
                return TransferBuilder.createExecutableExtension(element, classAttribute);
            }
            catch (CoreException e) {
                TransferBuilder.handleCreateExecutableException(result, e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        result[0] = TransferBuilder.createExecutableExtension(element, classAttribute);
                    }
                    catch (Exception e) {
                        TransferBuilder.handleCreateExecutableException(result, e);
                    }
                }
            });
        }
        return result[0];
    }

    protected static void handleCreateExecutableException(Object[] result, Throwable e) {
        Logger.logException(e);
        result[0] = null;
    }

    protected IDropAction createDropAction(IConfigurationElement element) {
        Object obj = null;
        obj = TransferBuilder.createExtension(element, ATT_CLASS);
        if (obj == null) {
            return null;
        }
        return obj instanceof IDropAction ? (IDropAction)DropActionProxy.newInstance(obj) : null;
    }

    protected IDropAction[] createDropActions(String transferId) {
        int i;
        if (this.cache == null) {
            return new IDropAction[0];
        }
        int num = this.cache.size();
        if (num == 0) {
            return new IDropAction[0];
        }
        IDropAction[] as = new IDropAction[num];
        int j = 0;
        int p = 0;
        while (p < PRIORITIES.length) {
            i = 0;
            while (i < num) {
                IDropAction a;
                IConfigurationElement element;
                Object obj = this.cache.get(i);
                if (obj instanceof IConfigurationElement && TAG_DROP_ACTION.equals((element = (IConfigurationElement)obj).getName()) && transferId.equals(element.getAttribute(ATT_TRANSFER_ID)) && (PRIORITIES[p].equals(element.getAttribute(ATT_PRIORITY)) || p == 2 && element.getAttribute(ATT_PRIORITY) == null) && (a = this.createDropAction(element)) != null) {
                    as[j] = a;
                    ++j;
                }
                ++i;
            }
            ++p;
        }
        if (num == j) {
            return as;
        }
        IDropAction[] as2 = new IDropAction[j];
        i = 0;
        while (i < j) {
            as2[i] = as[i];
            ++i;
        }
        return as2;
    }

    protected Transfer createTransfer(IConfigurationElement element) {
        Object obj = null;
        obj = TransferBuilder.createExtension(element, ATT_CLASS);
        if (obj == null) {
            return null;
        }
        return obj instanceof Transfer ? (Transfer)obj : null;
    }

    protected Transfer[] createTransfers() {
        int i;
        if (this.cache == null) {
            return new Transfer[0];
        }
        int num = this.cache.size();
        if (num == 0) {
            return new Transfer[0];
        }
        Transfer[] ts = new Transfer[num];
        int j = 0;
        int p = 0;
        while (p < PRIORITIES.length) {
            i = 0;
            while (i < num) {
                Transfer t;
                IConfigurationElement element;
                Object obj = this.cache.get(i);
                if (obj instanceof IConfigurationElement && TAG_TRANSFER.equals((element = (IConfigurationElement)obj).getName()) && (PRIORITIES[p].equals(element.getAttribute(ATT_PRIORITY)) || p == 2 && element.getAttribute(ATT_PRIORITY) == null) && (t = this.createTransfer(element)) != null) {
                    ts[j] = t;
                    ++j;
                }
                ++i;
            }
            ++p;
        }
        if (num == j) {
            return ts;
        }
        Transfer[] ts2 = new Transfer[j];
        i = 0;
        while (i < j) {
            ts2[i] = ts[i];
            ++i;
        }
        return ts2;
    }

    public Transfer[] getDragSourceTransfers(String editorId) {
        return this.getDragSourceTransfers(new String[]{editorId});
    }

    public Transfer[] getDragSourceTransfers(String[] editorIds) {
        long time0 = System.currentTimeMillis();
        this.readContributions(editorIds, TAG_DRAG_SOURCE_CONTRIBUTION, PL_DRAG_SOURCE_TRANSFERS);
        Transfer[] transfers = this.createTransfers();
        if (debugTime) {
            System.out.println(String.valueOf(this.getClass().getName()) + "#getDragSourceTransfers(" + editorIds + "): " + transfers.length + " transfers created in " + (System.currentTimeMillis() - time0) + "ms");
        }
        return transfers;
    }

    public IDropAction[] getDropActions(String editorId, String transferClassName) {
        return this.getDropActions(new String[]{editorId}, transferClassName);
    }

    public IDropAction[] getDropActions(String[] editorIds, String transferClassName) {
        long time0 = System.currentTimeMillis();
        this.readContributions(editorIds, TAG_DROP_TARGET_CONTRIBUTION, PL_DROP_TARGET_TRANSFERS);
        String transferId = this.getTransferIdOfClassName(transferClassName);
        IDropAction[] actions = this.createDropActions(transferId);
        if (debugTime) {
            System.out.println(String.valueOf(this.getClass().getName()) + "#getDropActions(" + editorIds + "): " + actions.length + " drop actions created in " + (System.currentTimeMillis() - time0) + "ms");
        }
        return actions;
    }

    public Transfer[] getDropTargetTransfers(String editorId) {
        return this.getDropTargetTransfers(new String[]{editorId});
    }

    public Transfer[] getDropTargetTransfers(String[] editorIds) {
        long time0 = System.currentTimeMillis();
        this.readContributions(editorIds, TAG_DROP_TARGET_CONTRIBUTION, PL_DROP_TARGET_TRANSFERS);
        Transfer[] transfers = this.createTransfers();
        if (debugTime) {
            String idlist = "";
            if (editorIds.length > 0) {
                int i = 0;
                while (i < editorIds.length) {
                    idlist = String.valueOf(idlist) + editorIds[i];
                    if (i < editorIds.length - 1) {
                        idlist = String.valueOf(idlist) + ",";
                    }
                    ++i;
                }
            }
            System.out.println(String.valueOf(this.getClass().getName()) + "#getDropTargetTransfers(" + idlist + "): " + transfers.length + " transfers created in " + (System.currentTimeMillis() - time0) + "ms");
        }
        return transfers;
    }

    protected String getTargetID(IConfigurationElement element) {
        String value = element.getAttribute(ATT_TARGET_ID);
        return value != null ? value : "???";
    }

    private String getTransferIdOfClassName(String className) {
        String id = "";
        int num = this.cache.size();
        if (className == null || this.cache == null || num == 0) {
            return id;
        }
        int i = 0;
        while (i < num) {
            IConfigurationElement element;
            Object obj = this.cache.get(i);
            if (obj instanceof IConfigurationElement && className.equals((element = (IConfigurationElement)obj).getAttribute(ATT_CLASS))) {
                id = element.getAttribute(ATT_ID);
                break;
            }
            ++i;
        }
        return id.length() != 0 ? id : className;
    }

    protected void readContributions(String[] ids, String tag, String extensionPoint) {
        this.cache = null;
        this.targetIDs = Arrays.asList(ids);
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, PLUGIN_ID, extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            String id = this.getTargetID(element);
            if (id == null || !this.targetIDs.contains(id)) {
                return true;
            }
        } else {
            if (tag.equals(TAG_TRANSFER)) {
                if (this.cache == null) {
                    this.cache = new ArrayList();
                }
                this.cache.add(element);
                return true;
            }
            if (tag.equals(TAG_DROP_ACTION)) {
                if (this.cache == null) {
                    this.cache = new ArrayList();
                }
                this.cache.add(element);
                return true;
            }
            return false;
        }
        this.readElementChildren(element);
        return true;
    }
}

