/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;

public class Literals {
    private Literals() {
    }

    public static String toLiteral(Object o) {
        return Literals.toLiteral(o, null);
    }

    public static String toLiteral(Object o, GenModel genModel) {
        if (o instanceof Boolean) {
            return Literals.toBooleanLiteral((Boolean)o, genModel);
        }
        if (o instanceof Byte) {
            return Literals.toByteLiteral((Byte)o, genModel);
        }
        if (o instanceof Short) {
            return Literals.toShortLiteral((Short)o, genModel);
        }
        if (o instanceof Integer) {
            return Literals.toIntLiteral((Integer)o, genModel);
        }
        if (o instanceof Long) {
            return Literals.toLongLiteral((Long)o, genModel);
        }
        if (o instanceof Float) {
            return Literals.toFloatLiteral(((Float)o).floatValue(), genModel);
        }
        if (o instanceof Double) {
            return Literals.toDoubleLiteral((Double)o, genModel);
        }
        if (o instanceof Character) {
            return Literals.toCharLiteral(((Character)o).charValue(), genModel);
        }
        if (o instanceof String) {
            return Literals.toStringLiteral((String)o, genModel);
        }
        if (o instanceof BigDecimal) {
            return Literals.toBigDecimalLiteral((BigDecimal)o, genModel);
        }
        if (o instanceof BigInteger) {
            return Literals.toBigIntegerLiteral((BigInteger)o, genModel);
        }
        if (o instanceof Date) {
            return Literals.toDateLiteral((Date)o, genModel);
        }
        if (o instanceof Class) {
            return Literals.toClassLiteral((Class)o, genModel);
        }
        return null;
    }

    public static String toBooleanLiteral(boolean b, GenModel genModel) {
        return b ? "true" : "false";
    }

    public static String toByteLiteral(byte b, GenModel genModel) {
        return Byte.toString(b);
    }

    public static String toShortLiteral(short s, GenModel genModel) {
        return Short.toString(s);
    }

    public static String toIntLiteral(int i, GenModel genModel) {
        return Integer.toString(i);
    }

    public static String toLongLiteral(long l, GenModel genModel) {
        return String.valueOf(Long.toString(l)) + "L";
    }

    public static String toFloatLiteral(float f, GenModel genModel) {
        if (Float.isNaN(f)) {
            return String.valueOf(Literals.importName("java.lang.Float", genModel)) + ".NaN";
        }
        if (Float.isInfinite(f)) {
            return f > 0.0f ? String.valueOf(Literals.importName("java.lang.Float", genModel)) + ".POSITIVE_INFINITY" : String.valueOf(Literals.importName("java.lang.Float", genModel)) + ".NEGATIVE_INFINITY";
        }
        return String.valueOf(Float.toString(f)) + "F";
    }

    public static String toDoubleLiteral(double d, GenModel genModel) {
        if (Double.isNaN(d)) {
            return String.valueOf(Literals.importName("java.lang.Double", genModel)) + ".NaN";
        }
        if (Double.isInfinite(d)) {
            return d > 0.0 ? String.valueOf(Literals.importName("java.lang.Double", genModel)) + ".POSITIVE_INFINITY" : String.valueOf(Literals.importName("java.lang.Double", genModel)) + ".NEGATIVE_INFINITY";
        }
        return Double.toString(d);
    }

    private static String importName(String name, GenModel genModel) {
        return genModel != null ? genModel.getImportedName(name) : name;
    }

    public static String toCharLiteral(char c, GenModel genModel) {
        StringBuffer result = new StringBuffer(8);
        result.append('\'');
        result.append(Literals.escapeChar(c));
        result.append('\'');
        return result.toString();
    }

    public static String toStringLiteral(String s, GenModel genModel) {
        if (s == null) {
            return "null";
        }
        int len = s.length();
        StringBuffer result = new StringBuffer(len + 16);
        result.append('\"');
        int i = 0;
        while (i < len) {
            result.append(Literals.escapeChar(s.charAt(i)));
            ++i;
        }
        result.append('\"');
        return result.toString();
    }

    private static String escapeChar(char c) {
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c >= ' ' && c < '\u007f') {
            return String.valueOf(c);
        }
        String num = Integer.toHexString(c);
        switch (num.length()) {
            case 1: {
                return "\\u000" + num;
            }
            case 2: {
                return "\\u00" + num;
            }
            case 3: {
                return "\\u0" + num;
            }
        }
        return "\\u" + num;
    }

    public static String toBigDecimalLiteral(BigDecimal bigDecimal, GenModel genModel) {
        if (bigDecimal == null) {
            return "null";
        }
        return "new " + Literals.importName("java.math.BigDecimal", genModel) + "(\"" + bigDecimal.toString() + "\")";
    }

    public static String toBigIntegerLiteral(BigInteger bigInteger, GenModel genModel) {
        if (bigInteger == null) {
            return "null";
        }
        return "new " + Literals.importName("java.math.BigInteger", genModel) + "(\"" + bigInteger.toString() + "\")";
    }

    public static String toDateLiteral(Date date, GenModel genModel) {
        String timeLiteral = Literals.toLongLiteral(date.getTime(), genModel);
        return "new " + Literals.importName("java.util.Date", genModel) + "(" + timeLiteral + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toClassLiteral(Class c, GenModel genModel) {
        if (c == null) {
            return "null";
        }
        String name = c.getName();
        int arrayDepth = 0;
        while (name.charAt(arrayDepth) == '[') {
            ++arrayDepth;
        }
        if (arrayDepth > 0) {
            if (name.charAt(arrayDepth) == 'B') {
                name = "byte";
            } else if (name.charAt(arrayDepth) == 'C') {
                name = "char";
            } else if (name.charAt(arrayDepth) == 'D') {
                name = "double";
            } else if (name.charAt(arrayDepth) == 'F') {
                name = "float";
            } else if (name.charAt(arrayDepth) == 'I') {
                name = "int";
            } else if (name.charAt(arrayDepth) == 'J') {
                name = "long";
            } else if (name.charAt(arrayDepth) == 'S') {
                name = "short";
            } else if (name.charAt(arrayDepth) == 'Z') {
                name = "boolean";
            } else {
                if (name.charAt(arrayDepth) != 'L') throw new IllegalArgumentException("Invalid class name: " + name);
                name = Literals.importName(name.substring(arrayDepth + 1, name.length() - 1), genModel);
            }
        } else if (!c.isPrimitive()) {
            name = Literals.importName(name, genModel);
        }
        StringBuffer result = new StringBuffer(name.length() + 2 * arrayDepth + 8);
        result.append(name);
        int i = 0;
        while (i < arrayDepth) {
            result.append('[');
            result.append(']');
            ++i;
        }
        result.append(".class");
        return result.toString();
    }
}

