/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.jdt.internal.integration;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.jdt.internal.integration.IJavaProjectMigrationDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JavaProjectMigrationOperation
extends AbstractDataModelOperation
implements IJavaProjectMigrationDataModelProperties {
    private static String WTP_MODULE_FILE_NAME = ".wtpmodules";

    public JavaProjectMigrationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        String projectName = this.model.getStringProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME");
        IProject project = ProjectUtilities.getProject((String)projectName);
        IFlexibleProject fProject = ComponentCore.createFlexibleProject((IProject)project);
        if (!fProject.isFlexible() && project.isAccessible() && project.exists() && this.shouldMigrate(project)) {
            try {
                if (!project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    this.addModuleCoreNature(project);
                }
                this.migrate(project);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return OK_STATUS;
    }

    protected boolean shouldMigrate(IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                return true;
            }
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        return false;
    }

    private void addModuleCoreNature(IProject project) {
        IProjectDescription description = null;
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            Logger.getLogger().log((Throwable)e);
        }
        String[] currentNatureIds = description.getNatureIds();
        String[] newNatureIds = new String[currentNatureIds.length + 1];
        System.arraycopy(currentNatureIds, 0, newNatureIds, 0, currentNatureIds.length);
        newNatureIds[currentNatureIds.length] = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
        description.setNatureIds(newNatureIds);
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e1) {
            Logger.getLogger().log((Throwable)e1);
        }
    }

    protected boolean wtpModuleFileExist(IProject project) {
        IFile file = project.getFile(WTP_MODULE_FILE_NAME);
        return file.exists();
    }

    protected void createComponent(String aComponentName, IProject aProject) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)aProject, (String)aComponentName);
        component.create(0, null);
        IVirtualFolder compRootFolder = component.getRootFolder();
        compRootFolder.getFolder((IPath)new Path("/"));
        IJavaProject javaProject = JavaCore.create((IProject)aProject);
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 3) {
                    IPath path = entries[i].getPath().removeFirstSegments(1);
                    if (path.isEmpty()) {
                        path = new Path("/");
                    }
                    IPath out = entries[i].getOutputLocation();
                    IVirtualFolder javaSourceFolder = compRootFolder.getFolder(out);
                    javaSourceFolder.createLink(path, 0, null);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        this.setupComponentType(aComponentName, aProject, "jst.utility");
    }

    protected void setupComponentType(String aComponentName, IProject aProject, String typeID) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)aProject, (String)aComponentName);
        ComponentType componentType = ComponentcoreFactory.eINSTANCE.createComponentType();
        componentType.setComponentTypeId(typeID);
        StructureEdit.setComponentType((IVirtualComponent)component, (ComponentType)componentType);
    }

    protected boolean migrate(IProject project) {
        if (this.wtpModuleFileExist(project)) {
            return false;
        }
        try {
            this.createComponent(project.getName(), project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

