/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.wsfinder;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.ws.internal.provisional.wsrt.WebServiceInfo;
import org.eclipse.wst.ws.internal.wsfinder.AbstractWebServiceLocator;

public class WSDLLocator
extends AbstractWebServiceLocator {
    protected List wsdlServices = null;

    public List getWebServices() {
        if (this.wsdlServices == null) {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                WSDLVisitor visitor = new WSDLVisitor();
                root.accept((IResourceVisitor)visitor);
                visitor.visit((IResource)root);
                this.wsdlServices = visitor.getWSDL();
            }
            catch (Exception exception) {}
        }
        return this.wsdlServices;
    }

    private class WSDLVisitor
    implements IResourceVisitor {
        private Vector wsdlURLs = new Vector();

        WSDLVisitor() {
        }

        public boolean visit(IResource resource) {
            String ext;
            if (resource.getType() == 1 && (ext = resource.getFileExtension()) != null && ext.equalsIgnoreCase("wsdl")) {
                String resPath = resource.getFullPath().toString();
                StringBuffer sb = new StringBuffer(resPath);
                WebServiceInfo wsInfo = new WebServiceInfo();
                wsInfo.setWsdlURL(sb.toString());
                this.wsdlURLs.add(wsInfo);
            }
            return true;
        }

        public Vector getWSDL() {
            return this.wsdlURLs;
        }
    }
}

