/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class WarFileDynamicClassLoader
extends ArchiveFileDynamicClassLoader {
    public WarFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl) {
        super(anArchive, parentCl, extraCl);
    }

    protected byte[] getClassBytesFor(String className) {
        String jarEntryName = ArchiveUtil.classNameToUri(className);
        String swizzledName = ArchiveUtil.concatUri("WEB-INF/classes/", jarEntryName, '/');
        try {
            InputStream in = this.getWarFile().getInputStream(swizzledName);
            return ArchiveUtil.inputStreamToBytes(in);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("io_ex_loading_EXC_", new Object[]{className}), ex);
        }
        List children = this.getWarFile().getLibs();
        int i = 0;
        while (i < children.size()) {
            try {
                InputStream in = ((Archive)children.get(i)).getInputStream(jarEntryName);
                return ArchiveUtil.inputStreamToBytes(in);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ex) {
                throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("io_ex_loading_EXC_", new Object[]{className}), ex);
            }
            ++i;
        }
        return super.getClassBytesFor(className);
    }

    private WARFile getWarFile() {
        return (WARFile)this.getArchive();
    }
}

