/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public class RarFileDynamicClassLoader
extends ArchiveFileDynamicClassLoader {
    public RarFileDynamicClassLoader(Archive anArchive, ClassLoader parentCl, ClassLoader extraCl) {
        super(anArchive, parentCl, extraCl);
    }

    protected byte[] getClassBytesFor(String className) {
        if (className == null) {
            return null;
        }
        List children = this.getRarFile().getArchiveFiles();
        String jarEntryName = ArchiveUtil.classNameToUri(className);
        int i = 0;
        while (i < children.size()) {
            try {
                InputStream in = ((Archive)children.get(i)).getInputStream(jarEntryName);
                return ArchiveUtil.inputStreamToBytes(in);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ex) {
                throw new ArchiveRuntimeException(CommonArchiveResourceHandler.getString("io_ex_loading_EXC_", new Object[]{className}), ex);
            }
            ++i;
        }
        return null;
    }

    private RARFile getRarFile() {
        return (RARFile)this.getArchive();
    }
}

