/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseWARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseconfigFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.wst.common.internal.emf.utilities.StringUtil;

public class LooseConfigRegister {
    public static final String LOOSE_CONFIG_PROPERTY = "was.loose.config";
    protected static LooseConfigRegister singleton;
    protected LooseConfiguration looseConfiguration;
    protected ResourceSet resourceSet;
    protected boolean loadAttempted = false;
    private Map looseEarMap;

    protected LooseConfigRegister() {
        this.initialize();
    }

    public static LooseConfigRegister singleton() {
        if (singleton == null) {
            singleton = new LooseConfigRegister();
        }
        return singleton;
    }

    public LooseApplication findLooseApplication(String earFileURI) {
        URI looseConfig;
        LooseApplication application;
        if (this.getLooseConfiguration() != null) {
            EList apps = this.getLooseConfiguration().getApplications();
            int i = 0;
            while (i < apps.size()) {
                LooseApplication app = (LooseApplication)apps.get(i);
                if (app.getUri().equals(earFileURI)) {
                    return app;
                }
                ++i;
            }
        }
        if ((this.getDocumentURI() == null || this.getDocumentURI().trim().length() == 0) && (application = this.loadLooseApplication(looseConfig = (URI)this.getLooseEarMap().get(earFileURI))) != null) {
            EList modules = application.getLooseArchives();
            int i = 0;
            while (i < modules.size()) {
                this.getLooseConfiguration().getApplications().add((Object)application);
                ++i;
            }
            return application;
        }
        return null;
    }

    public void addLooseMapping(Container container, String looseApplicationResource) {
        if (container != null) {
            this.addLooseMapping(ArchiveUtil.getOSUri(container.getURI()), looseApplicationResource);
        }
    }

    public void addLooseMapping(String earFileURI, String looseApplicationResource) {
        if (earFileURI != null) {
            LooseApplication app;
            if (this.getLooseEarMap().containsKey(earFileURI) && (app = this.findLooseApplicationIfLoaded(earFileURI)) != null) {
                Resource res = this.loadLooseApplicationResource(URI.createURI((String)looseApplicationResource));
                res.unload();
                this.removeLooseApplication(app);
            }
            this.getLooseEarMap().put(earFileURI, URI.createURI((String)looseApplicationResource));
        }
    }

    public LooseApplication findLooseApplicationIfLoaded(String earFileURI) {
        if (this.getLooseConfiguration() != null) {
            EList apps = this.getLooseConfiguration().getApplications();
            int i = 0;
            while (i < apps.size()) {
                LooseApplication app = (LooseApplication)apps.get(i);
                if (app.getUri().equals(earFileURI)) {
                    return app;
                }
                ++i;
            }
        }
        return null;
    }

    public void addLooseApplication(LooseApplication application) {
        this.getLooseConfiguration().getApplications().add((Object)application);
    }

    public void removeLooseApplication(LooseApplication application) {
        this.getLooseConfiguration().getApplications().remove((Object)application);
    }

    public void removeLooseMapping(String earFileURI) {
        if (earFileURI != null) {
            this.getLooseEarMap().remove(earFileURI);
        }
    }

    public LooseModule findLooseModule(LooseApplication app, String uri, String altDD) {
        EList archives = app.getLooseArchives();
        int i = 0;
        while (i < archives.size()) {
            LooseArchive element = (LooseArchive)archives.get(i);
            if (element.isModule() && StringUtil.stringsEqual((String)uri, (String)element.getUri()) && StringUtil.stringsEqual((String)altDD, (String)((LooseModule)element).getAltDD())) {
                return (LooseModule)element;
            }
            ++i;
        }
        return null;
    }

    public LooseModule findLooseModule(Module m, EARFile ear) {
        LooseApplication app = this.findLooseApplication(ear.getURI());
        return app == null ? null : this.findLooseModule(app, m.getUri(), m.getAltDD());
    }

    public void flush() {
        this.loadAttempted = false;
        this.looseConfiguration = null;
        this.resourceSet = new ResourceSetImpl();
    }

    protected void initialize() {
        this.resourceSet = new ResourceSetImpl();
    }

    protected void loadLooseConfiguration() {
        Resource res = this.loadLooseConfigurationResource();
        if (res != null && !res.getContents().isEmpty()) {
            this.setLooseConfiguration((LooseConfiguration)res.getContents().get(0));
        } else {
            this.setLooseConfiguration(LooseconfigFactory.eINSTANCE.createLooseConfiguration());
        }
        this.loadAttempted = true;
    }

    protected Resource loadLooseConfigurationResource() {
        String uri = this.getDocumentURI();
        if (ArchiveUtil.isNullOrEmpty(uri)) {
            return null;
        }
        try {
            return this.resourceSet.getResource(URI.createURI((String)uri), true);
        }
        catch (Exception ex) {
            throw new ArchiveRuntimeException("Exception occurred loading loose configuration", ex);
        }
    }

    protected LooseApplication loadLooseApplication(URI looseAppURI) {
        Resource res = this.loadLooseApplicationResource(looseAppURI);
        if (res != null && !res.getContents().isEmpty()) {
            return (LooseApplication)res.getContents().get(0);
        }
        return null;
    }

    protected Resource loadLooseApplicationResource(URI looseConfigURI) {
        if (looseConfigURI == null) {
            return null;
        }
        try {
            return this.resourceSet.getResource(looseConfigURI, true);
        }
        catch (Exception ex) {
            throw new ArchiveRuntimeException("Exception occurred loading loose application", ex);
        }
    }

    public LooseConfiguration primGetLooseConfiguration() {
        return this.looseConfiguration;
    }

    protected String getDocumentURI() {
        return System.getProperty(LOOSE_CONFIG_PROPERTY);
    }

    public LooseConfiguration getLooseConfiguration() {
        if (this.looseConfiguration == null && !this.loadAttempted) {
            this.loadLooseConfiguration();
        }
        return this.looseConfiguration;
    }

    public List getLooseChildren(LooseArchive loose) {
        if (loose != null) {
            if (loose.isEAR()) {
                return ((LooseApplication)loose).getLooseArchives();
            }
            if (loose.isWAR()) {
                return ((LooseWARFile)loose).getLooseLibs();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public LooseArchive findFirstLooseChild(String uri, LooseArchive loose) {
        List children = this.getLooseChildren(loose);
        int i = 0;
        while (i < children.size()) {
            LooseArchive child = (LooseArchive)children.get(i);
            if (StringUtil.stringsEqual((String)uri, (String)child.getUri())) {
                return loose;
            }
            ++i;
        }
        return null;
    }

    public void setLooseConfiguration(LooseConfiguration config) {
        this.looseConfiguration = config;
    }

    public boolean getLoadAttempted() {
        return this.loadAttempted;
    }

    public Map getLooseEarMap() {
        if (this.looseEarMap == null) {
            this.looseEarMap = new HashMap();
        }
        return this.looseEarMap;
    }
}

