/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.groups;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.navigator.internal.groups.NavigatorGroup;

public class NavigatorGroupLabelProvider
extends LabelProvider
implements ILabelProvider {
    private WorkbenchLabelProvider delegateProvider = new WorkbenchLabelProvider();

    public Image getImage(Object element) {
        if (element instanceof NavigatorGroup) {
            return this.retrieveAndStoreImage((NavigatorGroup)element);
        }
        if (element instanceof IProject) {
            return this.delegateProvider.getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof NavigatorGroup) {
            return ((NavigatorGroup)element).getDisplayName();
        }
        if (element instanceof IProject) {
            return this.delegateProvider.getText(element);
        }
        return null;
    }

    private Image retrieveAndStoreImage(NavigatorGroup group) {
        ImageDescriptor descriptor;
        ImageRegistry imageRegistry = this.getImageRegistry(group.getPluginID());
        if (imageRegistry == null) {
            return null;
        }
        String icon = group.getIcon();
        Image image = imageRegistry.get(icon);
        if ((image == null || image.isDisposed()) && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)group.getPluginID(), (String)icon)) != null && (image = descriptor.createImage()) != null) {
            imageRegistry.put(icon, image);
        }
        return image;
    }

    private ImageRegistry getImageRegistry(String pluginID) {
        IPluginDescriptor desc;
        if (pluginID != null && (desc = Platform.getPluginRegistry().getPluginDescriptor(pluginID)) != null) {
            Plugin plugin;
            try {
                plugin = desc.getPlugin();
            }
            catch (CoreException coreException) {
                return null;
            }
            if (plugin instanceof AbstractUIPlugin) {
                return ((AbstractUIPlugin)plugin).getImageRegistry();
            }
        }
        return null;
    }
}

