/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.ActionExpression;

public class CommonWizardDescriptor {
    public static final String ATT_WIZARD_ID = "wizardId";
    public static final String ATT_TYPE = "type";
    private static final String CHILD_ENABLEMENT = "enablement";
    private static final String EMF_ENABLEMENT = "emfEnablement";
    private String wizardId;
    private String type;
    private ActionExpression enablement;
    private IConfigurationElement configElement;

    public CommonWizardDescriptor(IConfigurationElement aConfigElement) throws WorkbenchException {
        this.configElement = aConfigElement;
        this.init();
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        return this.enablement != null && this.enablement.isEnabledFor(aStructuredSelection);
    }

    public boolean isEnabledFor(Object anElement) {
        return this.enablement != null && this.enablement.isEnabledFor(anElement);
    }

    void init() throws WorkbenchException {
        this.wizardId = this.configElement.getAttribute(ATT_WIZARD_ID);
        this.type = this.configElement.getAttribute(ATT_TYPE);
        if (this.wizardId == null || this.wizardId.length() == 0) {
            throw new WorkbenchException("Missing attribute: wizardId in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        if (this.type == null || this.type.length() == 0) {
            throw new WorkbenchException("Missing attribute: type in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
        IConfigurationElement[] children = this.configElement.getChildren(CHILD_ENABLEMENT);
        if (children.length == 1) {
            this.enablement = new ActionExpression(children[0]);
        } else if (children.length > 1) {
            throw new WorkbenchException("More than one element: enablement in common wizard extension: " + this.configElement.getDeclaringExtension().getUniqueIdentifier());
        }
    }

    public String getWizardId() {
        return this.wizardId;
    }

    public String getType() {
        return this.type;
    }
}

