/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import java.util.Properties;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorExtensionFilter;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.filters.NavigatorViewerFilter;

public class ExtensionFilterDescriptor {
    public static final String ID = "id";
    public static final String NAVIGATOR_EXTENSION_ID = "navigatorExtensionId";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String CLASS_NAME = "className";
    public static final String VIEW_ID = "viewId";
    public static final String ENABLED_BY_DEFAULT = "enabledByDefault";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private IConfigurationElement element = null;
    private String id = null;
    private String navigatorExtensionId = null;
    private String name = null;
    private String description = null;
    private String viewId = null;
    private boolean enabledByDefault = false;
    private Properties properties = null;
    private INavigatorExtensionFilter instance = null;
    private ViewerFilter viewerFilter;
    private String tostring;

    public ExtensionFilterDescriptor(IConfigurationElement element) {
        this.element = element;
        this.init();
    }

    public ExtensionFilterDescriptor(String filterId, String navigatorExtensionId, String name, String description, String viewerId, boolean enabledByDefault, ViewerFilter viewerFilter) {
        Assert.isNotNull((Object)filterId, (String)NavigatorMessages.getString("ExtensionFilterDescriptor.10"));
        Assert.isNotNull((Object)navigatorExtensionId, (String)NavigatorMessages.getString("ExtensionFilterDescriptor.11"));
        this.id = filterId;
        this.navigatorExtensionId = navigatorExtensionId;
        this.name = name;
        this.description = description;
        this.viewId = viewerId;
        this.enabledByDefault = enabledByDefault;
        this.viewerFilter = viewerFilter;
    }

    private void init() {
        if (this.element != null) {
            this.id = this.element.getAttribute(ID);
            this.navigatorExtensionId = this.element.getAttribute(NAVIGATOR_EXTENSION_ID);
            this.name = this.element.getAttribute("name");
            this.description = this.element.getAttribute(DESCRIPTION);
            this.viewId = this.element.getAttribute(VIEW_ID);
            this.enabledByDefault = Boolean.valueOf(this.element.getAttribute(ENABLED_BY_DEFAULT));
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            if (this.element != null) {
                IConfigurationElement[] children = this.element.getChildren(PROPERTY);
                String localName = null;
                String value = null;
                int i = 0;
                while (i < children.length) {
                    localName = children[i].getAttribute("name");
                    value = children[i].getAttribute(PROPERTY_VALUE);
                    this.properties.put(localName, value);
                    ++i;
                }
            }
        }
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getNavigatorExtensionId() {
        return this.navigatorExtensionId;
    }

    public INavigatorExtensionFilter getInstance() {
        if (this.instance == null) {
            if (this.element != null) {
                try {
                    this.instance = (INavigatorExtensionFilter)this.element.createExecutableExtension(CLASS_NAME);
                }
                catch (CoreException e) {
                    NavigatorPlugin.log(e.toString());
                }
            } else if (this.viewerFilter != null) {
                this.instance = new NavigatorViewerFilter(this.viewerFilter);
            }
        }
        return this.instance;
    }

    public String toString() {
        if (this.tostring == null) {
            this.tostring = String.valueOf(this.getClass().getName()) + "[id=\"" + this.getId() + "\", name=\"" + this.getName() + "\", enabledByDefault=\"" + this.isEnabledByDefault() + "\"]";
        }
        return this.tostring;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtensionFilterDescriptor) {
            return this.id.equals(((ExtensionFilterDescriptor)obj).id);
        }
        return false;
    }
}

