/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterViewerRegistry;

public class ExtensionFilterActivationManager {
    public static final String ACTIVATED_FILTERS = "activatedFilters";
    private final String viewerId;
    private final Set activatedFilters = new HashSet();
    private final ExtensionFilterViewerRegistry parentRegistry;

    public ExtensionFilterActivationManager(String theViewerId, ExtensionFilterViewerRegistry theParentRegistry) {
        this.viewerId = theViewerId;
        this.parentRegistry = theParentRegistry;
    }

    public void activateFilter(ExtensionFilterDescriptor descriptor, boolean enabled) {
        if (enabled) {
            this.getActivatedFilters().add(this.getFilterActivationPreferenceKey(descriptor));
        } else {
            this.getActivatedFilters().remove(this.getFilterActivationPreferenceKey(descriptor));
        }
    }

    public boolean isFilterActive(ExtensionFilterDescriptor descriptor) {
        return this.getActivatedFilters().contains(this.getFilterActivationPreferenceKey(descriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revertFilterActivations(String navigatorExtensionIdKey) {
        try {
            Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
            String activatedFiltersString = preferences.getString(this.getExtensionPreferenceKeyForFilterActivations(navigatorExtensionIdKey));
            Set set = this.activatedFilters;
            synchronized (set) {
                if (activatedFiltersString != null && activatedFiltersString.length() > 0) {
                    String activatedExtensionKey = null;
                    StringTokenizer tokenizer = new StringTokenizer(activatedFiltersString, ";");
                    while (tokenizer.hasMoreTokens()) {
                        activatedExtensionKey = tokenizer.nextToken();
                        if (activatedExtensionKey.length() <= 0) continue;
                        this.activatedFilters.add(activatedExtensionKey);
                    }
                } else {
                    List availableFilters = this.getParentRegistry().getExtensionFilterDescriptors(navigatorExtensionIdKey);
                    int i = 0;
                    while (i < availableFilters.size()) {
                        ExtensionFilterDescriptor filterDescriptor = (ExtensionFilterDescriptor)availableFilters.get(i);
                        if (filterDescriptor.isEnabledByDefault()) {
                            this.activatedFilters.add(this.getFilterActivationPreferenceKey(filterDescriptor));
                        }
                        ++i;
                    }
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFilterActivations() {
        Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
        Set set = this.activatedFilters;
        synchronized (set) {
            StringBuffer activatedFiltersStringBuffer = null;
            Iterator navigatorExtensionIdIterator = this.getParentRegistry().getNavigatorFilters().keySet().iterator();
            String navigatorExtensionId = null;
            while (navigatorExtensionIdIterator.hasNext()) {
                navigatorExtensionId = (String)navigatorExtensionIdIterator.next();
                activatedFiltersStringBuffer = new StringBuffer(";");
                List availableFilters = this.getParentRegistry().getExtensionFilterDescriptors(navigatorExtensionId);
                int i = 0;
                while (i < availableFilters.size()) {
                    ExtensionFilterDescriptor filterDescriptor = (ExtensionFilterDescriptor)availableFilters.get(i);
                    if (this.isFilterActive(filterDescriptor)) {
                        activatedFiltersStringBuffer.append(this.getFilterActivationPreferenceKey(filterDescriptor)).append(";");
                    }
                    ++i;
                }
                preferences.setValue(this.getExtensionPreferenceKeyForFilterActivations(navigatorExtensionId), activatedFiltersStringBuffer.toString());
            }
        }
        NavigatorPlugin.getDefault().savePluginPreferences();
    }

    protected String getExtensionPreferenceKeyForFilterActivations(String navigatorExtensionIdKey) {
        return String.valueOf(this.getViewerId()) + "." + navigatorExtensionIdKey + "." + ACTIVATED_FILTERS;
    }

    private Object getFilterActivationPreferenceKey(ExtensionFilterDescriptor filterDescriptor) {
        return this.getFilterActivationPreferenceKey(filterDescriptor.getNavigatorExtensionId(), filterDescriptor.getId());
    }

    private Object getFilterActivationPreferenceKey(String navigatorExtensionId, String filterId) {
        return String.valueOf(this.getViewerId()) + "." + navigatorExtensionId + "." + filterId + ".filterActivated";
    }

    protected String getViewerId() {
        return this.viewerId;
    }

    protected Set getActivatedFilters() {
        return this.activatedFilters;
    }

    protected ExtensionFilterViewerRegistry getParentRegistry() {
        return this.parentRegistry;
    }
}

