/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.IDescriptionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorActionService;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentServiceDescriptionProvider;
import org.eclipse.wst.common.navigator.internal.views.extensions.CommonOpenService;

public class CommonNavigatorManager
implements ISelectionChangedListener {
    private final CommonNavigator commonNavigator;
    private final NavigatorContentService contentService;
    private NavigatorActionService actionService;
    private final CommonOpenService commonOpenService;
    private IDescriptionProvider commonDescriptionProvider;
    private IStatusLineManager statusLineManager;
    private ILabelProvider labelProvider;

    public CommonNavigatorManager(CommonNavigator aNavigator) {
        this.commonNavigator = aNavigator;
        this.contentService = this.commonNavigator.getNavigatorContentService();
        this.commonOpenService = new CommonOpenService(this.contentService, this.commonNavigator);
        this.statusLineManager = this.commonNavigator.getViewSite().getActionBars().getStatusLineManager();
        this.commonDescriptionProvider = new NavigatorContentServiceDescriptionProvider(this.contentService);
        this.labelProvider = (ILabelProvider)this.commonNavigator.getCommonViewer().getLabelProvider();
        this.init();
    }

    private void init() {
        this.commonNavigator.getCommonViewer().addSelectionChangedListener(this);
        this.updateStatusBar(this.commonNavigator.getCommonViewer().getSelection());
        this.actionService = new NavigatorActionService((IViewPart)this.commonNavigator, (StructuredViewer)this.commonNavigator.getCommonViewer(), this.contentService);
        this.commonNavigator.getCommonViewer().addOpenListener(this.commonOpenService);
        this.initContextMenu();
    }

    protected void dispose() {
        this.commonNavigator.getCommonViewer().removeSelectionChangedListener(this);
        this.commonNavigator.getCommonViewer().removeOpenListener(this.commonOpenService);
        this.commonOpenService.dispose();
        this.actionService.dispose();
    }

    public void selectionChanged(SelectionChangedEvent anEvent) {
        this.updateStatusBar(anEvent.getSelection());
        if (anEvent.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)anEvent.getSelection();
            this.actionService.fillActionBars(this.commonNavigator.getViewSite().getActionBars(), structuredSelection);
        }
    }

    protected void restoreState(IMemento aMemento) {
        this.actionService.restoreState(aMemento);
    }

    protected void saveState(IMemento aMemento) {
        this.actionService.saveState(aMemento);
    }

    protected void fillContextMenu(IMenuManager aMenuManager) {
        ISelection selection = this.commonNavigator.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.actionService.fillContextMenu(aMenuManager, (IStructuredSelection)selection);
        } else {
            this.actionService.fillContextMenu(aMenuManager, (IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager(this.contentService.getViewerDescriptor().getPopupMenuId());
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommonNavigatorManager.this.fillContextMenu(manager);
            }
        });
        CommonViewer commonViewer = this.commonNavigator.getCommonViewer();
        Menu menu = menuMgr.createContextMenu((Control)commonViewer.getTree());
        commonViewer.getTree().setMenu(menu);
        this.commonNavigator.getSite().registerContextMenu(this.contentService.getViewerDescriptor().getPopupMenuId(), menuMgr, (ISelectionProvider)commonViewer);
    }

    protected void updateStatusBar(ISelection aSelection) {
        Image img = null;
        if (aSelection != null && !aSelection.isEmpty() && aSelection instanceof IStructuredSelection) {
            img = this.labelProvider.getImage(((IStructuredSelection)aSelection).getFirstElement());
        }
        this.statusLineManager.setMessage(img, this.commonDescriptionProvider.getDescription(aSelection));
    }
}

