/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroup;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroupType;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceUIResourceHandler;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsdd.EJBLink;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.WSDLPort;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class WebServicesNavigatorLabelProvider
extends AdapterFactoryLabelProvider
implements ILabelProvider {
    private static final String VIEWER_ID = "org.eclipse.wst.navigator.ui.WTPCommonNavigator";

    public WebServicesNavigatorLabelProvider() {
        super(WebServicesNavigatorLabelProvider.createAdapterFactory());
    }

    public static AdapterFactory createAdapterFactory() {
        return new DynamicAdapterFactory(VIEWER_ID);
    }

    public Image getImage(Object element) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        if (element instanceof WebServiceNavigatorGroup) {
            return J2EEUIPlugin.getDefault().getImage("webServicesFolder_obj");
        }
        if (element instanceof String) {
            return J2EEUIPlugin.getDefault().getImage("wsdl");
        }
        if (element instanceof WebServiceNavigatorGroupType) {
            return J2EEUIPlugin.getDefault().getImage("folder");
        }
        if (serviceHelper.isService(element)) {
            if (WebServicesManager.getInstance().isServiceInternal((EObject)element)) {
                return J2EEUIPlugin.getDefault().getImage("webServiceItemProvider_obj");
            }
            return J2EEUIPlugin.getDefault().getImage("extwebserviceitemprovider_obj");
        }
        if (serviceHelper.isWSDLResource(element)) {
            return J2EEUIPlugin.getDefault().getImage("wsdl");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
        String space = " ";
        if (element instanceof WebServiceDescription) {
            return this.getWebServiceDescriptionText((WebServiceDescription)element);
        }
        if (element instanceof PortComponent) {
            return String.valueOf(WebServiceUIResourceHandler.getString("PORT_UI_")) + space + super.getText(element);
        }
        if (element instanceof Handler) {
            return String.valueOf(WebServiceUIResourceHandler.getString("HANDLER_UI_")) + space + super.getText(element);
        }
        if (element instanceof WSDLPort) {
            return String.valueOf(WebServiceUIResourceHandler.getString("WSDL_PORT_UI_")) + space + super.getText(element);
        }
        if (element instanceof ServiceImplBean) {
            return WebServiceUIResourceHandler.getString("SERVICE_CLASSES_UI_");
        }
        if (element instanceof EJBLink) {
            return String.valueOf(WebServiceUIResourceHandler.getString("SERVICE_IMPL_UI_")) + space + super.getText(element);
        }
        if (element instanceof ServletLink) {
            return String.valueOf(WebServiceUIResourceHandler.getString("SERVICE_IMPL_UI_")) + space + super.getText(element);
        }
        if (serviceHelper.isService(element)) {
            return serviceHelper.getServiceLocalPart(element);
        }
        if (serviceHelper.isWSDLResource(element)) {
            String result = "";
            IFile file = WorkbenchResourceHelper.getFile((Resource)((Resource)element));
            result = file != null && file.exists() ? file.getFullPath().toString() : ((Resource)element).getURI().toString();
            return String.valueOf(WebServiceUIResourceHandler.getString("WSDL_UI_")) + space + result;
        }
        if (element instanceof ServiceRef) {
            String beanName14 = "";
            if (WebServicesManager.getInstance().isJ2EE14((ServiceRef)element) && ((ServiceRef)element).eContainer() instanceof Session) {
                beanName14 = String.valueOf(((Session)((ServiceRef)element).eContainer()).getName()) + ": ";
            }
            return String.valueOf(ProjectUtilities.getProject((EObject)((ServiceRef)element)).getName()) + ": " + beanName14 + ((ServiceRef)element).getServiceRefName();
        }
        return super.getText(element);
    }

    private String getWebServiceDescriptionText(WebServiceDescription description) {
        Resource res = description.eResource();
        IProject project = null;
        String projString = "";
        if (res != null) {
            project = WorkbenchResourceHelper.getProject((Resource)res);
        }
        if (project != null) {
            projString = String.valueOf(project.getName()) + ": ";
        }
        return String.valueOf(projString) + super.getText((Object)description);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

