/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets;

import org.eclipse.jst.ws.internal.consumption.ui.widgets.PreferencesSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WebServiceClientTypeWidget;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils;
import org.eclipse.jst.ws.internal.data.LabelsAndIds;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;

public class ServerWizardWidget
extends SimpleWidgetDataContributor {
    private WebServiceClientTypeWidget clientWidget_;
    private PreferencesSelectionWidget preferencesWidget_;
    private Listener statusListener_;
    private TypeRuntimeServer ids_;
    private LabelsAndIds labelIds_;
    private boolean displayPreferences_;
    private String INFOPOP_PWPR_PAGE = "PWPR0001";
    private String INFOPOP_PWPR_CHECKBOX_GENERATE_PROXY = "PWPR0005";
    private Button generateProxy_;
    private String INFOPOP_PWPR_COMBO_TYPE = "PWPR0010";
    private Combo webserviceType_;
    private String INFOPOP_PWPR_GROUP_SCENARIO_SERVICE = "PWPR0011";
    private Button startService_;
    private String INFOPOP_PWPR_CHECKBOX_START_WEB_PROJECT = "PWPR0009";
    private String INFOPOP_PWPR_CHECKBOX_TEST_SERVICE = "PWPR0013";
    private Button testService_;
    private String INFOPOP_PWPR_CHECKBOX_MONITOR_SERVICE = "PWPR0014";
    private Button monitorService;
    private String INFOPOP_PWPR_CHECKBOX_LAUNCH_WS = "PWPR0012";
    private Button launchUddi_;

    public ServerWizardWidget(boolean displayPreferences) {
        this.displayPreferences_ = displayPreferences;
    }

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "org.eclipse.jst.ws.consumption.ui";
        String createPluginId = "org.eclipse.jst.ws.creation.ui";
        MessageUtils msgUtils = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        UIUtils utils = new UIUtils(msgUtils, createPluginId);
        this.statusListener_ = statusListener;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(pluginId) + "." + this.INFOPOP_PWPR_PAGE);
        Composite serverComposite = utils.createComposite(parent, 1);
        Group serviceGroup = utils.createGroup(serverComposite, "GROUP_SCENARIO_SERVICE", "TOOLTIP_PWPR_GROUP_SCENARIO_SERVICE", this.INFOPOP_PWPR_GROUP_SCENARIO_SERVICE, 2, 10, 10);
        this.webserviceType_ = utils.createCombo((Composite)serviceGroup, "LABEL_WEBSERVICETYPE", "TOOLTIP_PWPR_COMBO_TYPE", this.INFOPOP_PWPR_COMBO_TYPE, 2060);
        this.webserviceType_.addListener(24, statusListener);
        Composite buttonsGroup = utils.createComposite((Composite)serviceGroup, 1);
        GridData buttonGrid = new GridData();
        buttonGrid.horizontalSpan = 2;
        buttonsGroup.setLayoutData((Object)buttonGrid);
        this.startService_ = utils.createCheckbox(buttonsGroup, "BUTTON_START_WEB_PROJECT", "TOOLTIP_PWPR_CHECKBOX_START_WEB_PROJECT", this.INFOPOP_PWPR_CHECKBOX_START_WEB_PROJECT);
        this.startService_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServerWizardWidget.this.handleStartPressed();
            }
        });
        this.launchUddi_ = utils.createCheckbox(buttonsGroup, "BUTTON_WS_PUBLISH", "TOOLTIP_PWPR_CHECKBOX_LAUNCH_WS", this.INFOPOP_PWPR_CHECKBOX_LAUNCH_WS);
        Composite proxyComposite = utils.createComposite(serverComposite, 1, 5, 0);
        this.generateProxy_ = utils.createCheckbox(proxyComposite, "BUTTON_GENERATE_PROXY", "TOOLTIP_PWPR_CHECKBOX_GENERATE_PROXY", this.INFOPOP_PWPR_CHECKBOX_GENERATE_PROXY);
        this.generateProxy_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServerWizardWidget.this.clientWidget_.enableWidget(ServerWizardWidget.this.generateProxy_.getSelection());
            }
        });
        this.clientWidget_ = new WebServiceClientTypeWidget();
        this.clientWidget_.addControls(serverComposite, statusListener);
        Composite testGroup = utils.createComposite(serverComposite, 1);
        this.testService_ = utils.createCheckbox(testGroup, "CHECKBOX_TEST_WEBSERVICE", "TOOLTIP_PWPR_CHECKBOX_TEST_SERVICE", this.INFOPOP_PWPR_CHECKBOX_TEST_SERVICE);
        this.monitorService = utils.createCheckbox(testGroup, "CHECKBOX_MONITOR_WEBSERVICE", "TOOLTIP_PWPR_CHECKBOX_MONITOR_SERVICE", this.INFOPOP_PWPR_CHECKBOX_MONITOR_SERVICE);
        if (this.displayPreferences_) {
            this.preferencesWidget_ = new PreferencesSelectionWidget();
            this.preferencesWidget_.addControls(serverComposite, statusListener);
        }
        return this;
    }

    private void handleStartPressed() {
        boolean enabled = this.startService_.getSelection();
        this.testService_.setEnabled(enabled);
        this.monitorService.setEnabled(enabled);
        this.launchUddi_.setEnabled(enabled);
        this.generateProxy_.setEnabled(enabled);
        this.clientWidget_.enableWidget(this.getGenerateProxy().booleanValue());
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientWidget_.setTypeRuntimeServer(ids);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientWidget_.getTypeRuntimeServer();
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        LabelsAndIds labelIds = WebServiceRuntimeExtensionUtils.getServiceTypeLabels();
        int selection = 0;
        String[] serviceIds = labelIds.getIds_();
        String selectedId = ids.getTypeId();
        this.webserviceType_.removeListener(24, this.statusListener_);
        this.webserviceType_.setItems(labelIds.getLabels_());
        int index = 0;
        while (index < serviceIds.length) {
            if (selectedId.equals(serviceIds[index])) {
                selection = index;
                break;
            }
            ++index;
        }
        this.webserviceType_.select(selection);
        this.webserviceType_.addListener(24, this.statusListener_);
        this.ids_ = ids;
        this.labelIds_ = labelIds;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        int selectionIndex = this.webserviceType_.getSelectionIndex();
        this.ids_.setTypeId(this.labelIds_.getIds_()[selectionIndex]);
        return this.ids_;
    }

    public Boolean getStartService() {
        return new Boolean(this.startService_.getSelection());
    }

    public void setStartService(Boolean value) {
        this.startService_.setSelection(value.booleanValue());
    }

    public Boolean getTestService() {
        return new Boolean(this.testService_.getSelection() && this.startService_.getSelection());
    }

    public void setTestService(Boolean value) {
        this.testService_.setSelection(value.booleanValue());
    }

    public Boolean getMonitorService() {
        return new Boolean(this.monitorService.getSelection() && this.startService_.getSelection());
    }

    public void setMonitorService(Boolean value) {
        this.monitorService.setSelection(value.booleanValue());
    }

    public Boolean getPublishService() {
        return new Boolean(this.launchUddi_.getSelection() && this.startService_.getSelection());
    }

    public void setPublishService(Boolean value) {
        this.launchUddi_.setSelection(value.booleanValue());
    }

    public Boolean getGenerateProxy() {
        return new Boolean(this.generateProxy_.getSelection() && this.startService_.getSelection());
    }

    public void setGenerateProxy(Boolean value) {
        this.generateProxy_.setSelection(value.booleanValue());
    }

    public ResourceContext getResourceContext() {
        return this.preferencesWidget_.getResourceContext();
    }

    public void setResourceContext(ResourceContext context) {
        this.preferencesWidget_.setResourceContext(context);
    }

    public void internalize() {
        this.handleStartPressed();
    }

    public Status getStatus() {
        SimpleStatus status = new SimpleStatus("");
        if (this.webserviceType_.getText().equals("")) {
            status = new SimpleStatus("", "", 4);
        }
        return status;
    }
}

