/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.server.core.IEJBModule;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericPublisher;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.internal.core.util.FileUtil;
import org.eclipse.jst.server.generic.servertype.definition.Module;
import org.eclipse.jst.server.generic.servertype.definition.PublisherData;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.osgi.framework.Bundle;

public class AntPublisher
extends GenericPublisher {
    private static final String JAR_PROTOCOL_PREFIX = "jar";
    public static final String PUBLISHER_ID = "org.eclipse.jst.server.generic.antpublisher";
    private static final String PROP_SERVER_PUBLISH_DIR = "server.publish.dir";
    private static final String PROP_PROJECT_WORKING_DIR = "project.working.dir";
    private static final String PROP_MODULE_DIR = "module.dir";
    private static final String PROP_MODULE_NAME = "module.name";
    private static final String MODULE_PUBLISH_TARGET_PREFIX = "target.publish.";
    private static final String MODULE_UNPUBLISH_TARGET_PREFIX = "target.unpublish.";
    private static final String DATA_NAME_BUILD_FILE = "build.file";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public IStatus[] publish(IModuleArtifact[] resource, IProgressMonitor monitor) {
        if (this.getModule().length > 1) {
            return null;
        }
        try {
            File file = this.computeBuildFile();
            this.runAnt(file.toString(), this.getPublishTargetsForModule(), this.getPublishProperties(), monitor);
        }
        catch (CoreException e) {
            Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorPublishAntpublisher, (Throwable)e);
            CorePlugin.getDefault().getLog().log((IStatus)s);
            return new IStatus[]{s};
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File computeBuildFile() throws CoreException {
        File file;
        Bundle bundle = Platform.getBundle((String)this.getServerRuntime().getServerTypeDefinition().getConfigurationElementNamespace());
        URL bundleUrl = bundle.getEntry(this.getBuildFile());
        URL fileURL = FileUtil.resolveURL(bundleUrl);
        if (!fileURL.getProtocol().equals(JAR_PROTOCOL_PREFIX)) return FileUtil.resolveFile(fileURL);
        OutputStream os = null;
        InputStream is = null;
        try {
            try {
                String filename = fileURL.getPath();
                String jarname = fileURL.getFile().substring(0, filename.indexOf(33));
                File jarFile = new File(new URL(jarname).getFile());
                JarFile jar = new JarFile(jarFile);
                File tmpFile = FileUtil.createTempFile(this.getBuildFile(), CorePlugin.getDefault().getStateLocation().toOSString());
                os = new FileOutputStream(tmpFile);
                String entryname = this.getBuildFile();
                if (entryname.startsWith("/")) {
                    entryname = entryname.substring(1);
                }
                JarEntry entry = jar.getJarEntry(entryname);
                is = jar.getInputStream(entry);
                FileUtil.copy(is, os);
                file = tmpFile;
                Object var13_16 = null;
            }
            catch (IOException e) {
                Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, "error creating temporary build file", (Throwable)e);
                CorePlugin.getDefault().getLog().log((IStatus)s);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (is != null) {
            is.close();
        }
        if (os == null) return file;
        os.close();
        return file;
    }

    private String getPublishTargetsForModule() {
        return this.doGetTargets(MODULE_PUBLISH_TARGET_PREFIX + this.getModuleTypeId());
    }

    private String getUnpublishTargetsForModule() {
        return this.doGetTargets(MODULE_UNPUBLISH_TARGET_PREFIX + this.getModuleTypeId());
    }

    private String doGetTargets(String dataname) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.getServerRuntime().getServerTypeDefinition().getPublisher(PUBLISHER_ID).getPublisherdata().iterator();
        while (iterator.hasNext()) {
            PublisherData data = (PublisherData)iterator.next();
            if (!dataname.equals(data.getDataname())) continue;
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(data.getDatavalue());
        }
        return buffer.toString();
    }

    private String getModuleTypeId() {
        return this.getModule()[0].getModuleType().getId();
    }

    private String getBuildFile() {
        Iterator iterator = this.getServerRuntime().getServerTypeDefinition().getPublisher(PUBLISHER_ID).getPublisherdata().iterator();
        while (iterator.hasNext()) {
            PublisherData data = (PublisherData)iterator.next();
            if (!DATA_NAME_BUILD_FILE.equals(data.getDataname())) continue;
            return this.getServerRuntime().getServerTypeDefinition().getResolver().resolveProperties(data.getDatavalue());
        }
        return null;
    }

    private Map getPublishProperties() {
        HashMap props = new HashMap();
        Map serverProperties = this.getServer().getServerInstancePropertiesImpl();
        Map properties = this.getServerRuntime().getServerInstanceProperties();
        properties.putAll(serverProperties);
        Iterator propertyIterator = properties.keySet().iterator();
        while (propertyIterator.hasNext()) {
            String property = (String)propertyIterator.next();
            String value = (String)properties.get(property);
            if (value == null || value.trim().length() <= 0) continue;
            props.put(property, properties.get(property));
        }
        Module module = this.getServerRuntime().getServerTypeDefinition().getModule(this.getModuleTypeId());
        String modDir = module.getPublishDir();
        modDir = this.getServerRuntime().getServerTypeDefinition().getResolver().resolveProperties(modDir);
        IModule iModule = this.getModule()[0];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWebModule webModule = (IWebModule)iModule.loadAdapter((Class)clazz, null);
        IModule iModule2 = this.getModule()[0];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jst.server.core.IEJBModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IEJBModule ejbModule = (IEJBModule)iModule2.loadAdapter((Class)clazz2, null);
        IModule iModule3 = this.getModule()[0];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IEnterpriseApplication earModule = (IEnterpriseApplication)iModule3.loadAdapter((Class)clazz3, null);
        String moduleName = "unknownmodule";
        String moduleDir = "";
        if (webModule != null) {
            moduleName = this.guessModuleName(webModule);
            moduleDir = webModule.getLocation().toString();
        }
        if (ejbModule != null) {
            moduleName = this.getModule()[0].getName();
            moduleDir = ejbModule.getLocation().toString();
        }
        if (earModule != null) {
            moduleName = this.getModule()[0].getName();
            moduleDir = earModule.getLocation().toString();
        }
        String pluginId = this.getServerRuntime().getServerTypeDefinition().getConfigurationElementNamespace();
        props.put(PROP_PROJECT_WORKING_DIR, this.getModule()[0].getProject().getWorkingLocation(pluginId).toString());
        props.put(PROP_MODULE_NAME, moduleName);
        props.put(PROP_MODULE_DIR, moduleDir);
        props.put(PROP_SERVER_PUBLISH_DIR, modDir);
        return props;
    }

    private String guessModuleName(IWebModule webModule) {
        String moduleName = this.getModule()[0].getName();
        String contextRoot = webModule.getContextRoot();
        if (contextRoot.charAt(0) == '/') {
            moduleName = contextRoot.substring(1);
        }
        return moduleName;
    }

    private void runAnt(String buildFile, String targets, Map properties, IProgressMonitor monitor) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, properties.get(PROP_MODULE_NAME) + " module publisher");
        wc.setContainer(null);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", buildFile);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTIES", properties);
        wc.setAttribute(IDebugUIConstants.ATTR_LAUNCH_IN_BACKGROUND, false);
        wc.setAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, true);
        wc.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, this.getServerRuntime().getVMInstall().getName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, this.getServerRuntime().getVMInstall().getVMInstallType().getId());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.eclipse.ant.internal.ui.antsupport.InternalAntRunner");
        wc.setAttribute("process_factory_id", "org.eclipse.ant.ui.remoteAntProcessFactory");
        this.setupAntLaunchConfiguration(wc);
        ILaunchConfiguration launchConfig = wc.doSave();
        launchConfig.launch("run", monitor);
    }

    protected void setupAntLaunchConfiguration(ILaunchConfigurationWorkingCopy wc) {
    }

    public IStatus[] unpublish(IProgressMonitor monitor) {
        if (this.getModule().length > 1) {
            return null;
        }
        try {
            File file = this.computeBuildFile();
            this.runAnt(file.toString(), this.getUnpublishTargetsForModule(), this.getPublishProperties(), monitor);
        }
        catch (CoreException e) {
            Status s = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.errorRemoveModuleAntpublisher, (Throwable)e);
            return new IStatus[]{s};
        }
        return null;
    }
}

