/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.emitter;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IEnterpriseBean;
import org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.IEmitterClasspathProvider;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.osgi.framework.Bundle;

public abstract class EjbEmitter {
    public static final String CLASSPATHPROVIDER = "classpathProvider";
    public static final String JAVACLASSPATHVARIABLEPREFIX = "WTPEJBEMITTER";
    public static final String EJBEMITTERPROJECT = ".WtpEjbEmitter";
    protected IConfigurationElement emitterConfig;
    protected IEmitterClasspathProvider classpathProvider;
    protected String base;
    protected IProgressMonitor monitor;

    public EjbEmitter(IConfigurationElement emitterConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException, CoreException {
        this.emitterConfig = emitterConfig;
        String pluginDescriptor = emitterConfig.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginDescriptor);
        Class c = bundle.loadClass(emitterConfig.getAttribute(CLASSPATHPROVIDER));
        this.classpathProvider = (IEmitterClasspathProvider)c.newInstance();
        this.base = bundle.getEntry("/").toString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(EJBEMITTERPROJECT);
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.delete(true, true, (IProgressMonitor)monitor);
    }

    public abstract String emitTypeComment(IEnterpriseBean var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException, CoreException;

    public abstract String emitTypeStub(IEnterpriseBean var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException, CoreException;

    public abstract String emitInterfaceMethods(IEnterpriseBean var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException, CoreException;

    public abstract String emitFields(IEnterpriseBean var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException, CoreException;

    protected WTPJETEmitter createJetEmitter(String uri) throws JETException {
        WTPJETEmitter emitter = new WTPJETEmitter(uri, this.getClass().getClassLoader());
        emitter.setProjectName(EJBEMITTERPROJECT);
        emitter.setIntelligentLinkingEnabled(true);
        Iterator iterator = this.classpathProvider.getClasspathItems().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            String cpItem = (String)iterator.next();
            emitter.addVariable(JAVACLASSPATHVARIABLEPREFIX + count++, cpItem);
        }
        return emitter;
    }

    public String generate(String templatesBase, String template, IEnterpriseBean enterpriseBean) throws CoreException {
        String uri = String.valueOf(this.base) + templatesBase + template;
        String result = "";
        IProgressMonitor aMonitor = this.getMonitor();
        WTPJETEmitter emitter = this.createJetEmitter(uri);
        result = emitter.generate(aMonitor, new Object[]{enterpriseBean});
        return result;
    }

    public IProgressMonitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new IProgressMonitor(){
                private boolean cancelled = false;

                public void beginTask(String name, int totalWork) {
                    System.out.println(this.getClass() + " Progress (" + totalWork + "): " + name);
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.cancelled;
                }

                public void setCanceled(boolean value) {
                    this.cancelled = value;
                }

                public void setTaskName(String name) {
                    System.out.println(this.getClass() + " Progress Task(" + name + "): ");
                }

                public void subTask(String name) {
                    System.out.println(this.getClass() + " Progress SubTask(" + name + "): ");
                }

                public void worked(int work) {
                }
            };
        }
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void deleteProject() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(EJBEMITTERPROJECT);
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.delete(true, true, (IProgressMonitor)monitor);
    }
}

