/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util.ui;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class BorderPainter
implements PaintListener {
    Color backgroundColor;
    Color foregroundColor;
    static Color borderColor;

    public BorderPainter() {
        Display display = Display.getCurrent();
        if (borderColor == null) {
            borderColor = new Color((Device)Display.getCurrent(), 195, 191, 179);
        }
        this.backgroundColor = display.getSystemColor(25);
        this.foregroundColor = display.getSystemColor(24);
    }

    public void paintControl(PaintEvent event) {
        Composite composite = (Composite)event.widget;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            GC gc;
            Rectangle b;
            Control c = children[i];
            if (!c.isEnabled()) {
                if (c instanceof Text || c instanceof Canvas || c instanceof List || c instanceof CCombo) {
                    b = c.getBounds();
                    gc = event.gc;
                    gc.setForeground(this.backgroundColor);
                    gc.setForeground(borderColor);
                    gc.drawRectangle(b.x - 2, b.y - 2, b.width + 3, b.height + 3);
                }
            } else if (c instanceof Text || c instanceof List || c instanceof CCombo) {
                b = c.getBounds();
                gc = event.gc;
                gc.setForeground(this.backgroundColor);
                gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                gc.setForeground(this.foregroundColor);
                gc.drawRectangle(b.x - 2, b.y - 2, b.width + 3, b.height + 3);
            } else if (c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                b = c.getBounds();
                gc = event.gc;
                gc.setForeground(this.foregroundColor);
                gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
            }
            ++i;
        }
    }
}

