/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editparts;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.util.WSDLSwitch;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.GroupEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.IConnectionManager;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractConnectionManager
implements IConnectionManager {
    public static final int PROPAGATE_FORWARD = 0;
    public static final int PROPAGATE_BACK = 1;
    public static final int SELECTED = 2;
    protected GroupEditPart groupEditPart;

    public AbstractConnectionManager(GroupEditPart groupEditPart) {
        this.groupEditPart = groupEditPart;
    }

    protected WSDLSwitch createSwitch(int selectionType) {
        return new WSDLSwitch();
    }

    public void propagateForward(Object model) {
        if (model instanceof WSDLElement) {
            WSDLSwitch theSwitch = this.createSwitch(0);
            theSwitch.doSwitch((EObject)model);
            this.groupEditPart.scrollToRevealInputConnection();
        } else {
            this.removeConnections();
        }
        this.propagateForwardToNext(model);
    }

    public void propagateBack(Object model) {
        if (model instanceof WSDLElement) {
            WSDLSwitch theSwitch = this.createSwitch(1);
            theSwitch.doSwitch((EObject)model);
            this.groupEditPart.scrollToRevealOutputConnection();
        } else {
            this.removeConnections();
        }
        this.propagateBackToPrevious(model);
    }

    public void setSelectedModelObject(Object model) {
        if (model instanceof Node) {
            Node node = (Node)model;
            while (node != null) {
                if ("http://schemas.xmlsoap.org/wsdl/".equals(node.getNamespaceURI())) break;
                node = node.getParentNode();
            }
            if (node instanceof Element) {
                model = WSDLEditorUtil.getInstance().findModelObjectForElement(this.groupEditPart.getDefinition(), (Element)node);
            }
        }
        if (model instanceof WSDLElement) {
            WSDLSwitch theSwitch = this.createSwitch(2);
            theSwitch.doSwitch((EObject)model);
        } else {
            this.removeConnections();
        }
        this.propagateForwardToNext(model);
        this.propagateBackToPrevious(model);
    }

    protected void removeConnections() {
        this.groupEditPart.setEmphasizedModelObject(null);
        this.groupEditPart.setInputConnectionModelObject(null);
        this.groupEditPart.setOutputConnectionModelObject(null);
    }

    protected void propagateForwardToNext(Object model) {
        IConnectionManager connectionManager;
        GroupEditPart group = this.groupEditPart.getNext();
        if (group != null && (connectionManager = group.getConnectionManager()) != null) {
            connectionManager.propagateForward(model);
        }
    }

    protected void propagateBackToPrevious(Object model) {
        IConnectionManager connectionManager;
        GroupEditPart group = this.groupEditPart.getPrevious();
        if (group != null && (connectionManager = group.getConnectionManager()) != null) {
            connectionManager.propagateBack(model);
        }
    }

    protected Binding getEnclosingBinding(EObject object) {
        Binding binding = null;
        if (object instanceof Binding) {
            binding = (Binding)object;
        } else if (object instanceof BindingOperation) {
            binding = (Binding)object.eContainer();
        } else if (object instanceof BindingInput || object instanceof BindingOutput || object instanceof BindingFault) {
            binding = (Binding)object.eContainer().eContainer();
        }
        return binding;
    }

    protected PortType getEnclosingPortType(EObject object) {
        PortType portType = null;
        if (object instanceof Operation) {
            portType = (PortType)object.eContainer();
        } else if (object instanceof Input || object instanceof Output || object instanceof Fault) {
            portType = object.eContainer() != null ? (PortType)object.eContainer().eContainer() : null;
        } else if (object instanceof PortType) {
            portType = (PortType)object;
        }
        return portType;
    }

    protected Operation getEnclosingOperation(EObject object) {
        Operation operation = null;
        if (object instanceof Operation) {
            operation = (Operation)object;
        } else if (object instanceof Input || object instanceof Output || object instanceof Fault) {
            operation = (Operation)object.eContainer();
        }
        return operation;
    }

    protected EObject getMessageReference(EObject object) {
        return object instanceof Input || object instanceof Output || object instanceof Fault ? object : null;
    }
}

