/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.gef.util.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class RoundedLineBorder
extends LineBorder {
    protected int arcLength;
    protected int lineStyle = 1;

    public RoundedLineBorder(Color c, int width, int arcLength) {
        super(c, width);
        this.arcLength = arcLength;
    }

    public RoundedLineBorder(int width, int arcLength) {
        super(width);
        this.arcLength = arcLength;
    }

    public RoundedLineBorder(Color c, int width, int arcLength, int lineStyle) {
        super(c, width);
        this.arcLength = arcLength;
        this.lineStyle = lineStyle;
    }

    public RoundedLineBorder(int width, int arcLength, int lineStyle) {
        super(width);
        this.arcLength = arcLength;
        this.lineStyle = lineStyle;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RoundedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        int width = this.getWidth();
        Color color = this.getColor();
        if (width % 2 == 1) {
            --RoundedLineBorder.tempRect.width;
            --RoundedLineBorder.tempRect.height;
        }
        tempRect.shrink(width / 2, width / 2);
        graphics.setLineWidth(width);
        graphics.setLineStyle(this.lineStyle);
        if (color != null) {
            graphics.setForegroundColor(color);
        }
        graphics.drawRoundRectangle(tempRect, this.arcLength, this.arcLength);
    }
}

