/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Node;

public abstract class WSDLElementUIAction
extends Action {
    protected WSDLElementCommand modelAction;
    private String undoDescription;
    private IEditorPart editorPart;
    static /* synthetic */ Class class$0;

    public WSDLElementUIAction(WSDLElementCommand action, String undoDescription, String label, ImageDescriptor image) {
        super(label, image);
        this.modelAction = action;
        this.undoDescription = undoDescription;
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    private String getUndoDescription() {
        return this.undoDescription;
    }

    private Node getOwnerNode() {
        if (this.getOwner() != null) {
            return this.getOwner().getElement();
        }
        return null;
    }

    protected abstract WSDLElement getOwner();

    protected abstract boolean showDialog();

    public void run() {
        boolean ok = this.showDialog();
        if (ok) {
            this.preRun();
            this.modelAction.run();
            this.format();
            this.selectObject();
            this.postRun();
        }
    }

    protected void preRun() {
    }

    protected void postRun() {
    }

    private void beginRecording() {
        Node node = this.getOwnerNode();
        if (node instanceof IDOMNode) {
            ((IDOMNode)node).getModel().beginRecording((Object)this, this.getUndoDescription());
        }
    }

    private void endRecording() {
        Node node = this.getOwnerNode();
        if (node instanceof IDOMNode) {
            ((IDOMNode)node).getModel().endRecording((Object)this);
        }
    }

    protected WSDLElement getWSDLElement() {
        return this.modelAction.getWSDLElement();
    }

    private void format() {
        Node parentNode = this.getOwnerNode();
        if (parentNode instanceof IDOMNode) {
            FormatProcessorXML formatProcessorXML = new FormatProcessorXML();
            formatProcessorXML.formatNode((Node)((IDOMNode)parentNode));
        }
    }

    private void selectObject() {
        WSDLElement object;
        if (this.editorPart != null && this.getOwner() != null && (object = this.getWSDLElement()) != null) {
            ISelectionProvider selectionProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((selectionProvider = (ISelectionProvider)this.editorPart.getAdapter((Class)clazz)) != null) {
                selectionProvider.setSelection((ISelection)new StructuredSelection((Object)object));
            }
        }
    }
}

