/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.actions.RenameAction;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.wsdl.ui.internal.widgets.NewComponentDialog;

class RenameDialogAction
extends Action {
    private WSDLElement element;
    private String defaultName = "NewName";
    private List usedNames = new ArrayList();
    private boolean useSmartRename = false;
    private boolean showDialog = false;

    public RenameDialogAction(WSDLElement selection) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_RENAME"));
        this.element = selection;
        this.initialize();
    }

    public void run() {
        NewComponentDialog dialog = new NewComponentDialog(WSDLEditorPlugin.getShell(), WSDLEditorPlugin.getWSDLString("_UI_ACTION_RENAME"), this.defaultName, this.usedNames);
        int rc = dialog.createAndOpen();
        if (rc == 0) {
            String result = dialog.getName();
            if (this.useSmartRename) {
                SmartRenameAction smartRename = new SmartRenameAction(this.element, result);
                smartRename.run();
            } else {
                RenameAction rename = new RenameAction(this.element, result);
                rename.run();
            }
        }
    }

    public void initialize() {
        if (this.element instanceof Fault) {
            this.usedNames = NameUtil.getUsedFaultNames((Operation)((Fault)this.element).eContainer());
            this.defaultName = ((Fault)this.element).getName();
            this.showDialog = true;
            this.useSmartRename = true;
        } else if (this.element instanceof Message) {
            this.usedNames = NameUtil.getUsedMessageNames(this.element.getEnclosingDefinition());
            this.defaultName = ((Message)this.element).getQName().getLocalPart();
            this.showDialog = true;
            this.useSmartRename = true;
        } else if (this.element instanceof Operation) {
            this.usedNames = NameUtil.getUsedOperationNames((PortType)((Operation)this.element).eContainer());
            this.defaultName = ((Operation)this.element).getName();
            this.showDialog = true;
            this.useSmartRename = true;
        } else if (this.element instanceof Part) {
            this.usedNames = NameUtil.getUsedPartNames((Message)((Part)this.element).eContainer());
            this.defaultName = ((Part)this.element).getName();
            this.showDialog = true;
            this.useSmartRename = true;
        } else if (this.element instanceof PortType) {
            this.usedNames = NameUtil.getUsedPortTypeNames(this.element.getEnclosingDefinition());
            this.defaultName = ((PortType)this.element).getQName().getLocalPart();
            this.showDialog = true;
            this.useSmartRename = false;
        } else if (this.element instanceof Port) {
            this.usedNames = NameUtil.getUsedPortNames((Service)((Port)this.element).eContainer());
            this.defaultName = ((Port)this.element).getName();
            this.showDialog = true;
            this.useSmartRename = true;
        } else if (this.element instanceof Binding) {
            this.usedNames = NameUtil.getUsedBindingNames(this.element.getEnclosingDefinition());
            this.defaultName = ((Binding)this.element).getQName().getLocalPart();
            this.showDialog = true;
            this.useSmartRename = false;
        } else if (this.element instanceof Service) {
            this.usedNames = NameUtil.getUsedServiceNames(this.element.getEnclosingDefinition());
            this.defaultName = ((Service)this.element).getQName().getLocalPart();
            this.showDialog = true;
            this.useSmartRename = false;
        }
        this.usedNames.remove(this.defaultName);
    }

    public boolean showRenameDialog() {
        return this.showDialog;
    }
}

