/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.common.FileResourceOutputStream;
import org.eclipse.wst.command.internal.provisional.env.core.common.Choice;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusException;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;

public final class FileResourceUtils {
    private static IWorkspace workspace_ = null;
    private static IWorkspaceRoot root_ = null;
    private static MessageUtils msg_ = new MessageUtils("org.eclipse.wst.command.internal.env.common.environment", (Object)new FileResourceUtils());

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static Choice[] getThreeStateFileOptions() {
        Vector<Choice> choices = new Vector<Choice>();
        choices.add(new Choice('Y', msg_.getMessage("LABEL_YES")));
        choices.add(new Choice('A', msg_.getMessage("LABEL_YES_TO_ALL")));
        choices.add(new Choice('C', msg_.getMessage("LABEL_CANCEL")));
        return choices.toArray(new Choice[choices.size()]);
    }

    public static IResource findResource(String absolutePathname) {
        if (absolutePathname == null) {
            return null;
        }
        return FileResourceUtils.findResource((IPath)new Path(absolutePathname));
    }

    public static IResource findResource(IPath absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        return FileResourceUtils.getWorkspaceRoot().findMember(absolutePath);
    }

    public static void copyFile(ResourceContext resourceContext, Plugin plugin, IPath sourcePath, IPath pathname, IPath targetPath, ProgressMonitor progressMonitor, StatusHandler statusMonitor) throws CoreException {
        try {
            IPath target = targetPath.append(pathname);
            IPath source = sourcePath == null ? pathname : sourcePath.append(pathname);
            InputStream input = plugin.openStream(source);
            FileResourceUtils.createFile(resourceContext, target, input, progressMonitor, statusMonitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, msg_.getMessage("MSG_ERROR_IO"), (Throwable)e));
        }
    }

    public static boolean deleteFile(ResourceContext resourceContext, IFile file, ProgressMonitor progressMonitor, StatusHandler statusMonitor) throws CoreException {
        if (file.exists()) {
            Choice choice;
            SimpleStatus status;
            if (!resourceContext.isOverwriteFilesEnabled()) {
                status = new SimpleStatus("", msg_.getMessage("MSG_ERROR_FILE_OVERWRITE_DISABLED", new Object[]{file.getParent().getFullPath().toString(), file.getName()}), 2);
                choice = statusMonitor.report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, FileResourceUtils.getThreeStateFileOptions());
                if (choice.getShortcut() == 'C') {
                    return false;
                }
                if (choice.getShortcut() == 'A') {
                    resourceContext.setOverwriteFilesEnabled(true);
                }
            }
            if (file.isReadOnly()) {
                if (!resourceContext.isCheckoutFilesEnabled()) {
                    status = new SimpleStatus("", msg_.getMessage("MSG_ERROR_FILE_CHECKOUT_DISABLED", new Object[]{file.getParent().getFullPath().toString(), file.getName()}), 2);
                    choice = statusMonitor.report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)status, FileResourceUtils.getThreeStateFileOptions());
                    if (choice.getShortcut() == 'C') {
                        return false;
                    }
                    if (choice.getShortcut() == 'A') {
                        resourceContext.setCheckoutFilesEnabled(true);
                    }
                }
                IFile[] files = new IFile[]{file};
                IStatus status2 = FileResourceUtils.getWorkspace().validateEdit(files, null);
                if (status2.getSeverity() == 4) {
                    SimpleStatus validateStatus = new SimpleStatus("", status2.getMessage(), 4);
                    statusMonitor.reportError((org.eclipse.wst.command.internal.provisional.env.core.common.Status)validateStatus);
                    return false;
                }
            }
            file.delete(true, null);
        }
        return true;
    }

    public static boolean deleteFolder(ResourceContext resourceContext, IFolder folder, ProgressMonitor progressMonitor, StatusHandler statusMonitor) throws CoreException {
        if (!folder.exists()) {
            return true;
        }
        boolean deleted = true;
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFile) {
                deleted = FileResourceUtils.deleteFile(resourceContext, (IFile)resource, progressMonitor, statusMonitor);
            }
            if (resource instanceof IFolder) {
                deleted = FileResourceUtils.deleteFolder(resourceContext, (IFolder)resource, progressMonitor, statusMonitor);
            }
            if (!deleted) break;
            ++i;
        }
        if (deleted) {
            folder.delete(true, true, null);
            return true;
        }
        return false;
    }

    public static IFile createFile(ResourceContext resourceContext, IPath absolutePath, InputStream inputStream, ProgressMonitor progressMonitor, StatusHandler statusHandler) throws CoreException {
        if (!absolutePath.isAbsolute()) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, msg_.getMessage("MSG_ERROR_PATH_NOT_ABSOLUTE", new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 1) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, msg_.getMessage("MSG_ERROR_PATH_EMPTY", new Object[]{absolutePath.toString()}), null));
        }
        if (absolutePath.segmentCount() < 2) {
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, msg_.getMessage("MSG_ERROR_PATH_NOT_FOLDER", new Object[]{absolutePath.toString()}), null));
        }
        IContainer parent = FileResourceUtils.makeFolderPath(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusHandler);
        String fileName = absolutePath.lastSegment();
        return FileResourceUtils.makeFile(resourceContext, parent, fileName, inputStream, progressMonitor, statusHandler);
    }

    public static IFile createFile(ResourceContext resourceContext, IProject project, IPath relativePath, InputStream inputStream, ProgressMonitor progressMonitor, StatusHandler statusMonitor) throws CoreException {
        IPath absolutePath = project.getFullPath().append(relativePath);
        return FileResourceUtils.createFile(resourceContext, absolutePath, inputStream, progressMonitor, statusMonitor);
    }

    public static OutputStream newFileOutputStream(ResourceContext context, IPath file, ProgressMonitor progressMonitor, StatusHandler statusHandler) {
        return new FileResourceOutputStream(context, file, progressMonitor, statusHandler);
    }

    public static IContainer makeFolderPath(ResourceContext resourceContext, IPath absolutePath, ProgressMonitor progressMonitor, StatusHandler statusHandler) throws CoreException {
        if (absolutePath.segmentCount() <= 1) {
            return FileResourceUtils.getWorkspaceRoot().getProject(absolutePath.segment(0));
        }
        IContainer parent = FileResourceUtils.makeFolderPath(resourceContext, absolutePath.removeLastSegments(1), progressMonitor, statusHandler);
        String folderName = absolutePath.lastSegment();
        return FileResourceUtils.makeFolder(resourceContext, parent, folderName, progressMonitor, statusHandler);
    }

    private static IFolder makeFolder(ResourceContext resourceContext, IContainer parent, String folderName, ProgressMonitor progressMonitor, StatusHandler statusHandler) throws CoreException {
        IResource child = parent.findMember(folderName);
        Choice result = null;
        if (child == null) {
            if (!resourceContext.isCreateFoldersEnabled()) {
                result = statusHandler.report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)new SimpleStatus("ResourceUtils", msg_.getMessage("MSG_ERROR_FOLDER_CREATION_DISABLED", new Object[]{parent.getFullPath().toString(), folderName}), 2, null), FileResourceUtils.getThreeStateFileOptions());
                if (result == null || result.getShortcut() == 'C') {
                    return null;
                }
                if (result.getShortcut() == 'A') {
                    resourceContext.setCreateFoldersEnabled(true);
                }
            }
            IFolder folder = parent.getFolder((IPath)new Path(folderName));
            folder.create(true, true, null);
            return folder;
        }
        if (child.getType() == 2) {
            return (IFolder)child;
        }
        throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, msg_.getMessage("MSG_ERROR_RESOURCE_NOT_FOLDER", new Object[]{parent.getFullPath().append(folderName).toString()}), null));
    }

    private static IFile makeFile(ResourceContext resourceContext, IContainer parent, String fileName, InputStream inputStream, ProgressMonitor progressMonitor, StatusHandler statusHandler) throws CoreException {
        IResource child = parent.findMember(fileName);
        Choice result = null;
        if (child != null) {
            if (child.getType() == 1) {
                if (!resourceContext.isOverwriteFilesEnabled()) {
                    result = statusHandler.report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)new SimpleStatus("ResourceUtils", msg_.getMessage("MSG_ERROR_FILE_OVERWRITE_DISABLED", new Object[]{parent.getFullPath().toString(), fileName}), 2), FileResourceUtils.getThreeStateFileOptions());
                    if (result == null || result.getShortcut() == 'C') {
                        return null;
                    }
                    if (result.getShortcut() == 'A') {
                        resourceContext.setOverwriteFilesEnabled(true);
                    }
                }
                if (child.getResourceAttributes().isReadOnly()) {
                    if (!resourceContext.isCheckoutFilesEnabled()) {
                        result = statusHandler.report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)new SimpleStatus("ResourceUtils", msg_.getMessage("MSG_ERROR_FILE_CHECKOUT_DISABLED", new Object[]{parent.getFullPath().toString(), fileName}), 2), FileResourceUtils.getThreeStateFileOptions());
                        if (result == null || result.getShortcut() == 'C') {
                            return null;
                        }
                        if (result.getShortcut() == 'A') {
                            resourceContext.setCheckoutFilesEnabled(true);
                        }
                    }
                    IFile[] files = new IFile[]{(IFile)child};
                    IStatus status = FileResourceUtils.getWorkspace().validateEdit(files, null);
                    SimpleStatus ss = new SimpleStatus(status.getPlugin(), status.getMessage(), status.getSeverity(), status.getException());
                    try {
                        statusHandler.report((org.eclipse.wst.command.internal.provisional.env.core.common.Status)ss);
                    }
                    catch (StatusException statusException) {
                        return null;
                    }
                }
                IFile file = parent.getFile((IPath)new Path(fileName));
                file.setContents(inputStream, true, true, null);
                return file;
            }
            throw new CoreException((IStatus)new Status(4, "ResourceUtils", 0, msg_.getMessage("MSG_ERROR_RESOURCE_NOT_FILE", new Object[]{parent.getFullPath().append(fileName)}), null));
        }
        IFile file = parent.getFile((IPath)new Path(fileName));
        file.create(inputStream, true, null);
        return file;
    }
}

