/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.common;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;

public final class EnvironmentUtils {
    public static org.eclipse.wst.command.internal.provisional.env.core.common.Status convertIStatusToStatus(IStatus istatus) {
        SimpleStatus status;
        String message = istatus.getMessage();
        IStatus[] children = istatus.getChildren();
        int noOfChildren = children.length;
        if (noOfChildren > 0) {
            org.eclipse.wst.command.internal.provisional.env.core.common.Status[] statusChildren = new org.eclipse.wst.command.internal.provisional.env.core.common.Status[noOfChildren];
            int i = 0;
            while (i < noOfChildren) {
                statusChildren[i] = EnvironmentUtils.convertIStatusToStatus(children[i]);
                ++i;
            }
            status = new SimpleStatus("", message, statusChildren);
        } else {
            int severity = istatus.getSeverity();
            int statusSeverity = 0;
            switch (severity) {
                case 4: {
                    statusSeverity = 4;
                    break;
                }
                case 2: {
                    statusSeverity = 2;
                    break;
                }
                case 1: {
                    statusSeverity = 1;
                    break;
                }
                case 0: {
                    statusSeverity = 0;
                }
            }
            Throwable e = istatus.getException();
            status = new SimpleStatus("", message, statusSeverity, e);
        }
        return status;
    }

    public static IStatus convertStatusToIStatus(org.eclipse.wst.command.internal.provisional.env.core.common.Status status, String pluginId) {
        Status istatus;
        String message = status.getMessage();
        Throwable throwable = status.getThrowable();
        if (status.hasChildren()) {
            org.eclipse.wst.command.internal.provisional.env.core.common.Status[] children = status.getChildren();
            int noOfChildren = children.length;
            IStatus[] istatusChildren = new IStatus[noOfChildren];
            int i = 0;
            while (i < noOfChildren) {
                istatusChildren[i] = EnvironmentUtils.convertStatusToIStatus(children[i], pluginId);
                ++i;
            }
            istatus = new MultiStatus(pluginId, 0, istatusChildren, message, throwable);
        } else {
            int severity = status.getSeverity();
            int istatusSeverity = 0;
            switch (severity) {
                case 4: {
                    istatusSeverity = 4;
                    break;
                }
                case 2: {
                    istatusSeverity = 2;
                    break;
                }
                case 1: {
                    istatusSeverity = 1;
                    break;
                }
                case 0: {
                    istatusSeverity = 0;
                }
            }
            istatus = new Status(istatusSeverity, pluginId, 0, message, throwable);
        }
        return istatus;
    }
}

