/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.tomcat.core.internal.FileUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.util.ProjectModule;

public class PublishOperation2
extends PublishOperation {
    protected TomcatServerBehaviour server;
    protected IModule module;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PublishOperation2(TomcatServerBehaviour server, IModule module) {
        super("Publish to server", "Publish Web modules to Tomcat server");
        this.server = server;
        this.module = module;
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        IModuleResourceDelta[] delta = this.server.getPublishedResourceDelta(new IModule[]{this.module});
        IPath path = this.server.getTempDirectory();
        path = path.append(this.module.getName());
        int size = delta.length;
        int i = 0;
        while (i < size) {
            this.handleDelta(path, delta[i]);
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)this.module.loadAdapter((Class)clazz, monitor);
        IModuleResource[] mr = pm.members();
        System.out.println(mr);
    }

    protected void handleDelta(IPath path, IModuleResourceDelta delta) throws CoreException {
        IPath path2;
        IModuleResource resource = delta.getModuleResource();
        int kind = delta.getKind();
        if (resource instanceof IModuleFile) {
            IModuleFile file = (IModuleFile)resource;
            if (kind == 3) {
                this.deleteFile(path, file);
            } else {
                this.copyFile(path, file);
            }
            return;
        }
        if (kind == 1) {
            path2 = path.append(resource.getModuleRelativePath()).append(resource.getName());
            path2.toFile().mkdirs();
        } else if (kind == 3) {
            path2 = path.append(resource.getModuleRelativePath()).append(resource.getName());
            path2.toFile().delete();
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            this.handleDelta(path, childDeltas[i]);
            ++i;
        }
    }

    protected void deleteFile(IPath path, IModuleFile file) {
        IPath path2 = path.append(file.getModuleRelativePath()).append(file.getName());
        path2.toFile().delete();
    }

    protected void copyFile(IPath path, IModuleFile file) throws CoreException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFile file2 = (IFile)file.getAdapter((Class)clazz);
        IPath path3 = path.append(file.getModuleRelativePath()).append(file.getName());
        File f = path3.toFile().getParentFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        FileUtil.copyFile(file2.getContents(), path3.toOSString());
    }
}

