/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IURLProvider;

public final class ServerUtils {
    private MessageUtils msgUtils_;
    private Hashtable serverIdToLabel_;
    private Hashtable serverLabelToId_;
    private static ServerUtils instance_;
    static /* synthetic */ Class class$0;

    public static ServerUtils getInstance() {
        if (instance_ == null) {
            instance_ = new ServerUtils();
        }
        return instance_;
    }

    public ServerUtils() {
        String pluginId = "org.eclipse.jst.ws";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
    }

    public void getServerLabelsAndIds() {
        this.serverIdToLabel_ = new Hashtable();
        this.serverLabelToId_ = new Hashtable();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int idx = 0;
        while (idx < serverTypes.length) {
            IServerType serverType = serverTypes[idx];
            String id = serverType.getId();
            String serverLabel = serverType.getName();
            if (id != null && serverLabel != null) {
                this.serverIdToLabel_.put(id, serverLabel);
                this.serverLabelToId_.put(serverLabel, id);
            }
            ++idx;
        }
    }

    public String getServerLabelForId(String factoryId) {
        if (this.serverIdToLabel_ == null) {
            this.getServerLabelsAndIds();
        }
        return (String)this.serverIdToLabel_.get(factoryId);
    }

    public String getServerIdForLabel(String factoryLabel) {
        if (this.serverLabelToId_ == null) {
            this.getServerLabelsAndIds();
        }
        return (String)this.serverLabelToId_.get(factoryLabel);
    }

    /*
     * Exception decompiling
     */
    public Status modifyModules(Environment env, IServer server, IModule module, boolean add, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [4 : 304->307)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IServer getServerForModule(IModule module, String serverTypeId, IServer server, boolean create, IProgressMonitor monitor) {
        if (server != null) {
            return server;
        }
        return ServerUtils.getServerForModule(module, serverTypeId, create, monitor);
    }

    public static IServer getServerForModule(IModule module, String serverTypeId, boolean create, IProgressMonitor monitor) {
        try {
            IServer[] servers = ServerUtil.getServersByModule((IModule)module, (IProgressMonitor)monitor);
            if (servers != null && servers.length > 0) {
                if (serverTypeId == null || serverTypeId.length() == 0) {
                    return servers[0];
                }
                int i = 0;
                while (i < servers.length) {
                    if (servers[i].getServerType().getId().equalsIgnoreCase(serverTypeId)) {
                        return servers[i];
                    }
                    ++i;
                }
            }
            return ServerUtils.createServer(module, serverTypeId, monitor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IServer getServerForModule(IModule module) {
        try {
            IServer[] servers = ServerUtil.getServersByModule((IModule)module, null);
            return servers != null && servers.length > 0 ? servers[0] : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IServer createServer(Environment env, IModule module, String serverTypeId, IProgressMonitor monitor) {
        IServer iServer;
        IServerWorkingCopy serverWC = null;
        IServer server = null;
        try {
            try {
                IServerType serverType = ServerCore.findServerType((String)serverTypeId);
                serverWC = serverType.createServer(serverTypeId, null, monitor);
                try {
                    if (serverWC != null) {
                        server = serverWC.saveAll(true, monitor);
                    }
                }
                catch (CoreException ce) {
                    SimpleStatus status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)ce);
                    env.getStatusHandler().reportError((Status)status);
                    IServer iServer2 = null;
                    Object var10_16 = null;
                    try {
                        if (serverWC == null) return iServer2;
                        serverWC.saveAll(true, monitor);
                        return iServer2;
                    }
                    catch (CoreException ce2) {
                        SimpleStatus status2 = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)ce2);
                        env.getStatusHandler().reportError((Status)status2);
                        return null;
                    }
                }
                if (server != null && module != null && module.getProject().exists()) {
                    IModule[] parentModules = server.getRootModules(module, monitor);
                    if (parentModules != null && parentModules.length != 0) {
                        module = parentModules[0];
                    }
                    serverWC.modifyModules(new IModule[]{module}, new IModule[0], monitor);
                }
                iServer = server;
                Object var10_17 = null;
            }
            catch (Exception e) {
                SimpleStatus status = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)e);
                env.getStatusHandler().reportError((Status)status);
                IServer iServer2 = null;
                Object var10_18 = null;
                try {}
                catch (CoreException ce2) {
                    SimpleStatus status2 = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)ce2);
                    env.getStatusHandler().reportError((Status)status2);
                    return null;
                }
                if (serverWC == null) return iServer2;
                serverWC.saveAll(true, monitor);
                return iServer2;
            }
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            try {}
            catch (CoreException ce2) {
                SimpleStatus status2 = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)ce2);
                env.getStatusHandler().reportError((Status)status2);
                return null;
            }
            if (serverWC == null) throw throwable;
            serverWC.saveAll(true, monitor);
            throw throwable;
        }
        try {}
        catch (CoreException ce2) {
            SimpleStatus status2 = new SimpleStatus("", this.msgUtils_.getMessage("MSG_ERROR_SERVER"), 4, (Throwable)ce2);
            env.getStatusHandler().reportError((Status)status2);
            return null;
        }
        if (serverWC == null) return iServer;
        serverWC.saveAll(true, monitor);
        return iServer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IServer createServer(IModule module, String serverTypeId, IProgressMonitor monitor) {
        IServer iServer;
        IServerWorkingCopy serverWC = null;
        IServer server = null;
        try {
            try {
                IServerType serverType = ServerCore.findServerType((String)serverTypeId);
                serverWC = serverType.createServer(serverTypeId, null, monitor);
                try {
                    if (serverWC != null) {
                        server = serverWC.saveAll(true, monitor);
                    }
                }
                catch (CoreException coreException) {
                    IServer iServer2 = null;
                    Object var7_9 = null;
                    try {
                        if (serverWC == null) return iServer2;
                        serverWC.saveAll(true, monitor);
                        return iServer2;
                    }
                    catch (CoreException coreException2) {
                        return null;
                    }
                }
                if (server != null && module != null) {
                    IModule[] parentModules = server.getRootModules(module, monitor);
                    if (parentModules != null && parentModules.length != 0) {
                        module = parentModules[0];
                    }
                    serverWC.modifyModules(new IModule[]{module}, new IModule[0], monitor);
                }
                iServer = server;
                Object var7_10 = null;
            }
            catch (Exception exception) {
                IServer iServer2 = null;
                Object var7_11 = null;
                try {}
                catch (CoreException coreException) {
                    return null;
                }
                if (serverWC == null) return iServer2;
                serverWC.saveAll(true, monitor);
                return iServer2;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            try {}
            catch (CoreException coreException) {
                return null;
            }
            if (serverWC == null) throw throwable;
            serverWC.saveAll(true, monitor);
            throw throwable;
        }
        try {}
        catch (CoreException coreException) {
            return null;
        }
        if (serverWC == null) return iServer;
        serverWC.saveAll(true, monitor);
        return iServer;
    }

    public static String[] getServerTypeIdsByModule(IVirtualComponent component) {
        IServer[] servers;
        IProject project = component.getProject();
        String[] serverIds = null;
        if (project != null && (servers = ServerUtil.getServersByModule((IModule)ServerUtils.getModule(project, component.getName()), null)) != null) {
            serverIds = new String[servers.length];
            int index = 0;
            while (index < servers.length) {
                serverIds[index] = servers[index].getId();
                ++index;
            }
        }
        if (serverIds == null) {
            serverIds = new String[]{};
        }
        return serverIds;
    }

    public static String[] getServerTypeIdsByModule(IProject project) {
        IServer[] servers;
        Vector<String> serverIds = new Vector<String>();
        if (project != null && (servers = ServerUtil.getServersByModule((IModule)ResourceUtils.getModule(project), null)) != null && servers.length > 0) {
            int i = 0;
            while (i < servers.length) {
                serverIds.add(servers[i].getId());
                ++i;
            }
        }
        return serverIds.toArray(new String[serverIds.size()]);
    }

    public static IModule getModule(IProject project, String componentName) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        IModule moduleFound = null;
        int index = 0;
        while (index < modules.length) {
            if (modules[index].getName().equals(componentName)) {
                moduleFound = modules[index];
                break;
            }
            ++index;
        }
        return moduleFound;
    }

    public static String getWebComponentURL(IProject project, String componentName) {
        String webProjectURL;
        block15: {
            webProjectURL = null;
            IModule module = ServerUtils.getModule(project, componentName);
            if (module != null) {
                IServer serverInstance = ServerUtils.getServerForModule(module);
                if (serverInstance != null) {
                    URL url;
                    IURLProvider urlProvider;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.IURLProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((urlProvider = (IURLProvider)serverInstance.loadAdapter((Class)clazz, null)) != null && (url = urlProvider.getModuleRootURL(module)) != null) {
                        String s = url.toString();
                        webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
                    }
                } else {
                    IRuntime projectTarget = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
                    if (projectTarget != null) {
                        String projectTargetId = projectTarget.getRuntimeType().getId();
                        String serverFactoryId = ServerUtils.getFactoryIdFromRuntimeTargetId(projectTargetId);
                        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
                        try {
                            URL url;
                            IURLProvider urlProvider;
                            if (serverType == null) break block15;
                            IServerWorkingCopy serverWC = serverType.createServer(null, null, projectTarget, null);
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.IURLProvider");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((urlProvider = (IURLProvider)serverWC.loadAdapter((Class)clazz, null)) != null && (url = urlProvider.getModuleRootURL(module)) != null) {
                                String s = url.toString();
                                webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
                            }
                        }
                        catch (CoreException ce) {
                            Logger.getLogger().log((Throwable)ce);
                        }
                    }
                }
            }
        }
        return webProjectURL;
    }

    public static String getWebComponentURL(IProject project, String componentName, String serverFactoryId, IServer server) {
        IServer serverInstance;
        String webProjectURL = null;
        IModule module = ServerUtils.getModule(project, componentName);
        if (module != null && (serverInstance = ServerUtils.getServerForModule(module, serverFactoryId, server, true, (IProgressMonitor)new NullProgressMonitor())) != null) {
            URL url;
            IURLProvider urlProvider;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.IURLProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((urlProvider = (IURLProvider)serverInstance.loadAdapter((Class)clazz, null)) != null && (url = urlProvider.getModuleRootURL(module)) != null) {
                String s = url.toString();
                webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
            }
        }
        return webProjectURL;
    }

    public static String getEncodedWebComponentURL(IProject project, String componentName) {
        int index;
        String url = ServerUtils.getWebComponentURL(project, componentName);
        if (url != null && (index = url.lastIndexOf(47)) != -1) {
            StringBuffer encodedURL = new StringBuffer();
            encodedURL.append(url.substring(0, index + 1));
            try {
                String ctxtRoot = URLEncoder.encode(url.substring(index + 1, url.length()), "UTF-8");
                int plusIndex = ctxtRoot.indexOf(43);
                while (plusIndex != -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(ctxtRoot.substring(0, plusIndex));
                    sb.append("%20");
                    sb.append(ctxtRoot.substring(plusIndex + 1, ctxtRoot.length()));
                    ctxtRoot = sb.toString();
                    plusIndex = ctxtRoot.indexOf(43);
                }
                encodedURL.append(ctxtRoot);
            }
            catch (IOException iOException) {}
            url = encodedURL.toString();
        }
        return url;
    }

    public static IServer getDefaultExistingServer(IVirtualComponent component) {
        IProject project = component.getProject();
        IModule module = ServerUtils.getModule(project, component.getName());
        IServer preferredServer = ServerCore.getDefaultServer((IModule)module);
        if (preferredServer != null) {
            return preferredServer;
        }
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)module, null);
        if (configuredServers != null && configuredServers.length > 0) {
            preferredServer = configuredServers[0];
        } else {
            IServer[] nonConfiguredServers = ServerUtil.getAvailableServersForModule((IModule)module, (boolean)false, null);
            if (nonConfiguredServers != null && nonConfiguredServers.length > 0) {
                preferredServer = nonConfiguredServers[0];
            }
        }
        return preferredServer;
    }

    public static IServer getDefaultExistingServer(IProject project) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        IServer preferredServer = null;
        if (modules.length > 0) {
            preferredServer = ServerCore.getDefaultServer((IModule)modules[0]);
        }
        if (preferredServer != null) {
            return preferredServer;
        }
        IServer[] configuredServers = ServerUtil.getServersByModule((IModule)ResourceUtils.getModule(project), null);
        if (configuredServers != null && configuredServers.length > 0) {
            return configuredServers[0];
        }
        IServer[] nonConfiguredServers = ServerUtil.getAvailableServersForModule((IModule)ResourceUtils.getModule(project), (boolean)false, null);
        if (nonConfiguredServers != null && nonConfiguredServers.length > 0) {
            return nonConfiguredServers[0];
        }
        return null;
    }

    public static String getServerTargetIdFromFactoryId(String serverFactoryId, String moduleType, String j2eeVersion) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType == null) {
            return null;
        }
        String serverRuntimeTypeId = serverType.getRuntimeType().getId();
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion(j2eeVersion);
        List<IRuntime> runtimes = Arrays.asList(ServerUtil.getRuntimes((String)moduleType, (String)stJ2EEVersion));
        int i = 0;
        while (i < runtimes.size()) {
            IRuntime runtime = runtimes.get(i);
            String thisRuntimeTypeId = runtime.getRuntimeType().getId();
            if (thisRuntimeTypeId.equals(serverRuntimeTypeId)) {
                return runtime.getId();
            }
            ++i;
        }
        return null;
    }

    public static String getRuntimeTargetIdFromFactoryId(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType != null) {
            String serverRuntimeId = serverType.getRuntimeType().getId();
            return serverRuntimeId;
        }
        return "";
    }

    public static String getFactoryIdFromRuntimeTargetId(String runtimeTargetId) {
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int i = 0;
        while (i < serverTypes.length) {
            IRuntimeType runtimeTyp = serverTypes[i].getRuntimeType();
            if (runtimeTyp != null && runtimeTyp.getId().equals(runtimeTargetId)) {
                return serverTypes[i].getId();
            }
            ++i;
        }
        return "";
    }

    public static String getServerTypeIdFromFactoryId(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType != null) {
            String serverTypeId = serverType.getId();
            return serverTypeId;
        }
        return "";
    }

    public static boolean isTargetValidForEAR(String runtimeTargetId, String j2eeVersion) {
        if (runtimeTargetId == null) {
            return false;
        }
        String earModuleType = "j2ee.ear";
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion(j2eeVersion);
        List<IRuntime> runtimes = Arrays.asList(ServerUtil.getRuntimes((String)earModuleType, (String)stJ2EEVersion));
        int i = 0;
        while (i < runtimes.size()) {
            IRuntime runtime = runtimes.get(i);
            String thisId = runtime.getRuntimeType().getId();
            if (thisId.equals(runtimeTargetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTargetValidForProjectType(String runtimeTargetId, String j2eeVersion, String projectType) {
        if (runtimeTargetId == null) {
            return false;
        }
        if (projectType == null || projectType.length() == 0) {
            return false;
        }
        String stJ2EEVersion = ServerUtils.getServerTargetJ2EEVersion(j2eeVersion);
        List<IRuntime> runtimes = Arrays.asList(ServerUtil.getRuntimes((String)projectType, (String)stJ2EEVersion));
        int i = 0;
        while (i < runtimes.size()) {
            IRuntime runtime = runtimes.get(i);
            String thisId = runtime.getRuntimeType().getId();
            if (thisId.equals(runtimeTargetId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getServerTargetJ2EEVersion(String j2eeVersion) {
        if (j2eeVersion == null || j2eeVersion.length() == 0) {
            return null;
        }
        int j2eeVersionInt = Integer.parseInt(j2eeVersion);
        switch (j2eeVersionInt) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
        }
        return null;
    }

    public static String getServerTargetModuleType(int moduleType) {
        switch (moduleType) {
            case 1: {
                return "j2ee.web";
            }
            case 2: {
                return "j2ee.ejb";
            }
            case 4: {
                return "j2ee.appclient";
            }
            case 8: {
                return "j2ee.ear";
            }
        }
        return null;
    }
}

