/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.common.StringUtils;
import org.eclipse.jst.ws.internal.plugin.WebServicePlugin;
import org.eclipse.wst.command.internal.env.eclipse.EclipseLog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.internal.FlexibleJavaProjectPreferenceUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IURLProvider;

public final class ResourceUtils {
    private static IWorkspaceRoot root_ = null;
    private static IWorkspace workspace_ = null;
    public static byte PROJECT_TYPE_NONE = 0;
    public static byte PROJECT_TYPE_JAVA = 1;
    public static byte PROJECT_TYPE_WEB = (byte)2;
    public static byte PROJECT_TYPE_EJB = (byte)4;
    public static byte PROJECT_TYPE_APPCLIENT = (byte)8;
    public static String SERVLET_EXT = "/servlet/rpcrouter";
    private static final String DEFAULT_CLIENT_WEB_PROJECT_EXT = "Client";
    private static final String DEFAULT_CLIENT_EJB_PROJECT_EXT = "EJBClient";
    private static final String DEFAULT_EJB_PROJECT_NAME = "WebServiceEJBProject";
    private static final String DEFAULT_EJB_COMPONENT_NAME = "WebServiceEJB";
    private static final String DEFAULT_WEB_PROJECT_NAME = "WebServiceProject";
    private static final String DEFAULT_WEB_COMPONENT_NAME = "WebServiceProject";
    private static final String DEFAULT_ROUTER_PROJECT_EXT = "Router";
    private static final String DEFAULT_SERVICE_EAR_PROJECT_NAME = "WebServiceProjectEAR";
    private static final String DEFAULT_SERVICE_EAR_COMPONENT_NAME = "WebServiceProjectEAR";
    private static final String DEFAULT_CLIENT_EAR_PROJECT_NAME = "WebServiceProjectClientEAR";
    private static final String DEFAULT_CLIENT_EAR_COMPONENT_NAME = "WebServiceProjectClientEAR";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public static IResource findResource(String absolutePathname) {
        if (absolutePathname == null) {
            return null;
        }
        return ResourceUtils.findResource((IPath)new Path(absolutePathname));
    }

    public static IResource findResource(IPath absolutePath) {
        if (absolutePath == null) {
            return null;
        }
        return ResourceUtils.getWorkspaceRoot().findMember(absolutePath);
    }

    public static IStatus validateName(String segment, int typeMask) {
        return ResourceUtils.getWorkspace().validateName(segment, typeMask);
    }

    public static IStatus validatePath(String path, int typeMask) {
        return ResourceUtils.getWorkspace().validatePath(path, typeMask);
    }

    public static IStatus validateJavaTypeName(String typeName) {
        int a = typeName.indexOf(91);
        if (a > 0) {
            typeName = typeName.substring(0, a);
        }
        if (ResourceUtils.isPrimitiveJavaType(typeName)) {
            return new Status(0, "org.eclipse.jst.ws", 0, "", null);
        }
        return JavaConventions.validateJavaTypeName((String)typeName);
    }

    public static boolean isPrimitiveJavaType(String typeName) {
        return typeName.equals("boolean") || typeName.equals("char") || typeName.equals("byte") || typeName.equals("short") || typeName.equals("int") || typeName.equals("long") || typeName.equals("float") || typeName.equals("double");
    }

    public static IProject getProjectOf(IPath absolutePath) {
        String projectName;
        if (absolutePath.isAbsolute() && (projectName = absolutePath.segment(0)) != null) {
            return ResourceUtils.getWorkspaceRoot().getProject(projectName);
        }
        return null;
    }

    public static IVirtualComponent getComponentOf(IPath absolutePath) {
        String componentName;
        if (absolutePath.isAbsolute() && (componentName = absolutePath.segment(1)) != null) {
            String projectName = absolutePath.segment(0);
            IProject project = ResourceUtils.getWorkspaceRoot().getProject(projectName);
            if (projectName != null) {
                return ComponentCore.createComponent((IProject)project, (String)componentName);
            }
        }
        return null;
    }

    public static IVirtualComponent getComponentOf(IResource res) {
        IVirtualResource[] vresources = ComponentCore.createResources((IResource)res);
        IVirtualComponent vcomp = null;
        if (vresources != null && vresources.length > 0) {
            IVirtualResource vres = vresources[0];
            vcomp = vres.getComponent();
        }
        return vcomp;
    }

    public static boolean isJavaProject(IProject project) {
        return JavaCore.create((IProject)project) != null;
    }

    public static boolean isTrueJavaProject(IProject project) {
        return !ResourceUtils.isWebProject(project) && !ResourceUtils.isAppClientProject(project) && !ResourceUtils.isEARProject(project) && !ResourceUtils.isEJBProject(project) && ResourceUtils.isJavaProject(project);
    }

    /*
     * Exception decompiling
     */
    public static boolean isWebProject(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 44->47)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean isEARProject(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 54->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean isEJBProject(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 54->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean isAppClientProject(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 54->60)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte getProjectType(IProject project) {
        byte projectType = PROJECT_TYPE_NONE;
        if (ResourceUtils.isJavaProject(project)) {
            projectType = (byte)(projectType | PROJECT_TYPE_JAVA);
        }
        if (ResourceUtils.isWebProject(project)) {
            projectType = (byte)(projectType | PROJECT_TYPE_WEB);
        }
        if (ResourceUtils.isEJBProject(project)) {
            projectType = (byte)(projectType | PROJECT_TYPE_EJB);
        }
        return projectType;
    }

    public static String getComponentType(IProject project, String componentName) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project, (String)componentName);
        return ResourceUtils.getComponentType(comp);
    }

    public static String getComponentType(IVirtualComponent component) {
        return component.getComponentTypeId();
    }

    public static String getProjectTypeAsString(IProject project) {
        if (ResourceUtils.isEJBProject(project)) {
            return WebServicePlugin.getMessage("%LABEL_EJB");
        }
        if (ResourceUtils.isWebProject(project)) {
            return WebServicePlugin.getMessage("%LABEL_WEB");
        }
        if (ResourceUtils.isJavaProject(project)) {
            return WebServicePlugin.getMessage("%LABEL_JAVA");
        }
        return "";
    }

    public static IModule getModule(IProject project) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules != null && modules.length != 0) {
            return modules[0];
        }
        return null;
    }

    public static IPath getJavaOutputLocation(IProject project) {
        IPath outputLocation = null;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                outputLocation = javaProject.getOutputLocation();
            }
        }
        catch (JavaModelException javaModelException) {}
        EclipseLog log = new EclipseLog();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.ResourceUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log.log(1, 5032, clazz, "getJavaOutputLocation", (Object)("project=" + project + ",outputLocation=" + outputLocation));
        return outputLocation;
    }

    public static IPath getJavaSourceLocation(IProject project) {
        IPath sourceLocation = null;
        IPackageFragmentRoot[] fragmentRoots = ResourceUtils.getJavaPackageFragmentRoots(project);
        int i = 0;
        while (i < fragmentRoots.length && sourceLocation == null) {
            try {
                IResource fragmentRoot = fragmentRoots[i].getCorrespondingResource();
                if (fragmentRoot != null && fragmentRoot.getProject().equals((Object)project) && fragmentRoot.getType() != 1) {
                    sourceLocation = fragmentRoot.getFullPath();
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        EclipseLog log = new EclipseLog();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.ResourceUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log.log(1, 5030, clazz, "getJavaSourceLocation", (Object)("project=" + project + ",sourceLocation=" + sourceLocation));
        return sourceLocation;
    }

    public static IPath getJavaSourceLocation(IProject project, String compName) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (String)compName);
        return ResourceUtils.getJavaSourceLocation(component);
    }

    public static IPath getJavaSourceLocation(IVirtualComponent comp) {
        if (comp != null) {
            IVirtualFolder folder = comp.getRootFolder().getFolder((IPath)new Path("/WEB-INF/classes"));
            return folder.getWorkspaceRelativePath();
        }
        return null;
    }

    public static IPath[] getAllJavaSourceLocations(IProject project) {
        Vector<IPath> pathVector = new Vector<IPath>();
        IPackageFragmentRoot[] fragmentRoots = ResourceUtils.getJavaPackageFragmentRoots(project);
        int i = 0;
        while (i < fragmentRoots.length) {
            try {
                IResource fragmentRoot = fragmentRoots[i].getCorrespondingResource();
                if (fragmentRoot != null && fragmentRoot.getProject().equals((Object)project) && fragmentRoot.getType() != 1) {
                    pathVector.add(fragmentRoot.getFullPath());
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return (IPath[])pathVector.toArray(new Path[pathVector.size()]);
    }

    public static IPath[] getAllJavaSourceLocations(IVirtualComponent[] components) {
        if (components != null) {
            ArrayList<IPath> javaSourcePaths = new ArrayList<IPath>();
            int i = 0;
            while (i < components.length) {
                IPath path = ResourceUtils.getJavaSourceLocation(components[i]);
                javaSourcePaths.add(path);
                ++i;
            }
            return javaSourcePaths.toArray(new IPath[0]);
        }
        return null;
    }

    public static IPackageFragmentRoot getJavaSourcePackageFragmentRoot(IProject project) {
        IPackageFragmentRoot packageFragmentRoot = null;
        IPath javaSourceLocation = ResourceUtils.getJavaSourceLocation(project);
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                packageFragmentRoot = javaProject.findPackageFragmentRoot(javaSourceLocation);
            }
        }
        catch (JavaModelException javaModelException) {}
        return packageFragmentRoot;
    }

    public static IPackageFragmentRoot[] getJavaPackageFragmentRoots(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                return packageFragmentRoots;
            }
        }
        catch (JavaModelException javaModelException) {}
        return new IPackageFragmentRoot[0];
    }

    public static IClasspathEntry[] getJavaClasspath(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
                return classpathEntries;
            }
        }
        catch (JavaModelException javaModelException) {}
        return new IClasspathEntry[0];
    }

    public static IFolder getWebComponentServerRoot(IProject project, String componentName) {
        IFolder webModuleServerRoot = null;
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project, (String)componentName);
        if (vc.exists()) {
            webModuleServerRoot = StructureEdit.getOutputContainerRoot((IVirtualComponent)vc);
        }
        return webModuleServerRoot;
    }

    public static String getWebProjectURL(IProject project, String serverFactoryId, IServer server) {
        IServer serverInstance;
        String webProjectURL = null;
        IModule module = ResourceUtils.getModule(project);
        if (module != null && (serverInstance = ServerUtils.getServerForModule(module, serverFactoryId, server, true, (IProgressMonitor)new NullProgressMonitor())) != null) {
            URL url;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.IURLProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((url = ((IURLProvider)serverInstance.getAdapter((Class)clazz)).getModuleRootURL(module)) != null) {
                String s = url.toString();
                webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
            }
        }
        EclipseLog log = new EclipseLog();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.ResourceUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log.log(1, 5036, clazz, "getWebProjectURL", (Object)("project=" + project + ",webProjectURL=" + webProjectURL));
        return webProjectURL;
    }

    public static String getWebProjectURL(IProject project) {
        IServer serverInstance;
        String webProjectURL = null;
        IModule module = ResourceUtils.getModule(project);
        if (module != null && (serverInstance = ServerUtils.getServerForModule(module)) != null) {
            URL url;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.IURLProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((url = ((IURLProvider)serverInstance.getAdapter((Class)clazz)).getModuleRootURL(module)) != null) {
                String s = url.toString();
                webProjectURL = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
            }
        }
        EclipseLog log = new EclipseLog();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.ws.internal.common.ResourceUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log.log(1, 5037, clazz, "getWebProjectURL", (Object)("project=" + project + ",webProjectURL=" + webProjectURL));
        return webProjectURL;
    }

    public static String getEncodedWebProjectURL(IProject project) {
        int index;
        String url = ResourceUtils.getWebProjectURL(project);
        if (url != null && (index = url.lastIndexOf(47)) != -1) {
            StringBuffer encodedURL = new StringBuffer();
            encodedURL.append(url.substring(0, index + 1));
            try {
                String ctxtRoot = URLEncoder.encode(url.substring(index + 1, url.length()), "UTF-8");
                int plusIndex = ctxtRoot.indexOf(43);
                while (plusIndex != -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(ctxtRoot.substring(0, plusIndex));
                    sb.append("%20");
                    sb.append(ctxtRoot.substring(plusIndex + 1, ctxtRoot.length()));
                    ctxtRoot = sb.toString();
                    plusIndex = ctxtRoot.indexOf(43);
                }
                encodedURL.append(ctxtRoot);
            }
            catch (IOException iOException) {}
            url = encodedURL.toString();
        }
        return url;
    }

    public static String getJavaResourcePackageName(IPath absolutePath) {
        try {
            IPath javaFolderPath = absolutePath.removeLastSegments(1);
            IProject project = ResourceUtils.getProjectOf(absolutePath);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IPackageFragment fragment = javaProject.findPackageFragment(javaFolderPath);
                if (fragment != null) {
                    return fragment.getElementName();
                }
                IPath outputPath = ResourceUtils.getJavaOutputLocation(project);
                if (outputPath.isPrefixOf(javaFolderPath)) {
                    IPath javaPackagePath = javaFolderPath.removeFirstSegments(outputPath.segmentCount());
                    return javaPackagePath.isEmpty() ? null : javaPackagePath.toString().replace('/', '.');
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IPath getJavaResourcePackagePath(IPath absolutePath) {
        String packageName = ResourceUtils.getJavaResourcePackageName(absolutePath);
        return packageName == null ? null : new Path(packageName.replace('.', '/'));
    }

    public static IPath getJavaResourceRootPath(IPath absolutePath) {
        try {
            IProject project = ResourceUtils.getProjectOf(absolutePath);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                IPackageFragmentRoot[] pfrs = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < pfrs.length) {
                    IPath fragmentPath;
                    IResource fragmentRoot = pfrs[i].getCorrespondingResource();
                    if (fragmentRoot != null && (fragmentPath = fragmentRoot.getFullPath()).isPrefixOf(absolutePath)) {
                        return fragmentPath;
                    }
                    ++i;
                }
                IPath outputPath = ResourceUtils.getJavaOutputLocation(project);
                if (outputPath.isPrefixOf(absolutePath)) {
                    return outputPath;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static void copyIndexedFilesToOS(Plugin plugin, IPath sourcePath, IPath indexPathname, IPath targetPath, IProgressMonitor progressMonitor) throws IOException {
        InputStream input = plugin.openStream(indexPathname);
        Enumeration filenames = StringUtils.parseFilenamesFromStream(input);
        ResourceUtils.copyEnumeratedFilesToOS(plugin, sourcePath, filenames, targetPath, progressMonitor);
    }

    public static void copyEnumeratedFilesToOS(Plugin plugin, IPath sourcePath, Enumeration pathnames, IPath targetPath, IProgressMonitor progressMonitor) throws IOException {
        while (pathnames.hasMoreElements()) {
            String filename = (String)pathnames.nextElement();
            ResourceUtils.copyFileToOS(plugin, sourcePath, (IPath)new Path(filename), targetPath, progressMonitor);
        }
    }

    public static void copyFileToOS(Plugin plugin, IPath sourcePath, IPath pathname, IPath targetPath, IProgressMonitor progressMonitor) throws IOException {
        IPath target = targetPath.append(pathname);
        IPath source = sourcePath == null ? pathname : sourcePath.append(pathname);
        InputStream input = plugin.openStream(source);
        FileOutputStream output = new FileOutputStream(target.toOSString());
        ResourceUtils.copyStream(input, output);
        input.close();
        ((OutputStream)output).close();
    }

    public static int copyStream(InputStream input, OutputStream output) throws IOException {
        int t = 0;
        byte[] buffer = new byte[1024];
        int n = input.read(buffer);
        while (n >= 0) {
            output.write(buffer, 0, n);
            t += n;
            n = input.read(buffer);
        }
        return t;
    }

    public static void createParentDirectoryFor(String pathname) throws IOException {
        File file = new File(pathname);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static IResource getResourceFromSelection(Object obj) throws CoreException {
        IResource res = null;
        if (obj != null) {
            EnterpriseBean ejbBean;
            IProject ejbProject;
            if (obj instanceof IResource) {
                res = (IResource)obj;
            } else if (obj instanceof IJavaElement) {
                IJavaElement javaElement = (IJavaElement)obj;
                res = javaElement.getCorrespondingResource();
            } else if (obj instanceof EnterpriseBean && (ejbProject = ProjectUtilities.getProject((EObject)(ejbBean = (EnterpriseBean)obj))) != null) {
                res = ejbProject;
            }
        }
        return res;
    }

    public static String getResourceURI(IResource resource) {
        String uri = null;
        IPath location = resource.getLocation();
        if (location != null) {
            uri = "file:" + location.toString();
        }
        return uri;
    }

    public static String getPlatformResourceURI(IResource resource) {
        String uri = null;
        IPath location = resource.getFullPath();
        if (location != null) {
            uri = "platform:/resource" + location.toString();
        }
        return uri;
    }

    public static String getBindingNamespace(String beanName) {
        return "http://www." + beanName.toLowerCase() + ".com/definitions/" + beanName + "RemoteInterface";
    }

    public static String getSchemaNamespace(String beanName) {
        return "http://www." + beanName.toLowerCase() + ".com/schemas/" + beanName + "RemoteInterface";
    }

    public static String getServletURL(IProject project, String serverFactoryId, IServer server) {
        return ResourceUtils.getServletURL(ResourceUtils.getWebProjectURL(project, serverFactoryId, server));
    }

    public static String getServletURL(String webProjectURL) {
        if (webProjectURL == null) {
            return null;
        }
        return String.valueOf(webProjectURL) + SERVLET_EXT;
    }

    public static String getClientWebProjectName(String projectName, String typeId) {
        String baseClientWebProjectName = String.valueOf(projectName) + DEFAULT_CLIENT_WEB_PROJECT_EXT;
        boolean foundWebProject = false;
        int i = 1;
        if (ResourceUtils.isSkeletonEJBType(typeId)) {
            baseClientWebProjectName = String.valueOf(projectName) + "WS" + DEFAULT_CLIENT_WEB_PROJECT_EXT;
        }
        String clientWebProjectName = baseClientWebProjectName;
        while (!foundWebProject) {
            IPath projectPath = new Path(clientWebProjectName).makeAbsolute();
            IProject project = ResourceUtils.getProjectOf(projectPath);
            if (project.exists() && !ResourceUtils.isWebProject(project)) {
                clientWebProjectName = String.valueOf(baseClientWebProjectName) + i;
                ++i;
                continue;
            }
            foundWebProject = true;
        }
        return clientWebProjectName;
    }

    public static String[] getClientProjectComponentName(String projectName, String componentName, boolean isEJB) {
        String clientProjectName = null;
        String clientComponentName = null;
        if (isEJB) {
            clientProjectName = String.valueOf(projectName) + DEFAULT_CLIENT_EJB_PROJECT_EXT;
            clientComponentName = String.valueOf(componentName) + DEFAULT_CLIENT_EJB_PROJECT_EXT;
        } else {
            clientProjectName = String.valueOf(projectName) + DEFAULT_CLIENT_WEB_PROJECT_EXT;
            clientComponentName = String.valueOf(componentName) + DEFAULT_CLIENT_WEB_PROJECT_EXT;
        }
        if (!FlexibleJavaProjectPreferenceUtil.getMultipleModulesPerProjectProp()) {
            clientComponentName = clientProjectName;
        }
        return new String[]{clientProjectName, clientComponentName};
    }

    public static boolean isSkeletonEJBType(String typeID) {
        return typeID.equals("org.eclipse.jst.ws.type.wsdl.ejb");
    }

    public static String getDefaultEJBProjectName() {
        return DEFAULT_EJB_PROJECT_NAME;
    }

    public static String getDefaultEJBComponentName() {
        return DEFAULT_EJB_COMPONENT_NAME;
    }

    public static String getDefaultWebProjectName() {
        return "WebServiceProject";
    }

    public static String getDefaultWebComponentName() {
        return "WebServiceProject";
    }

    public static String getDefaultClientExtension() {
        return DEFAULT_CLIENT_WEB_PROJECT_EXT;
    }

    public static String getRouterProjectName(String projectName) {
        return String.valueOf(projectName) + DEFAULT_ROUTER_PROJECT_EXT;
    }

    public static String getDefaultServiceEARProjectName() {
        return "WebServiceProjectEAR";
    }

    public static String getDefaultServiceEARComponentName() {
        return "WebServiceProjectEAR";
    }

    public static String getDefaultClientEARProjectName() {
        return "WebServiceProjectClientEAR";
    }

    public static String getDefaultClientEARComponentName() {
        return "WebServiceProjectClientEAR";
    }
}

