/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.operation;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationOperation;
import org.eclipse.wst.web.internal.WSTWebPlugin;
import org.eclipse.wst.web.internal.operation.ISimpleWebModuleCreationDataModelProperties;

public class SimpleWebModuleCreationOperation
extends ProjectCreationOperation
implements ISimpleWebModuleCreationDataModelProperties {
    public SimpleWebModuleCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = super.execute(monitor, info);
        IProject project = (IProject)this.model.getProperty(PROJECT);
        IFolder webContentFolder = project.getFolder(this.getWebContentFolderPreference());
        try {
            IFolder cssFolder;
            if (!webContentFolder.exists()) {
                webContentFolder.create(true, true, null);
            }
            if (!(cssFolder = project.getFolder(webContentFolder.getProjectRelativePath().append("theme"))).exists()) {
                cssFolder.create(true, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return status;
    }

    private String getWebContentFolderPreference() {
        String webContentFolder = WSTWebPlugin.getDefault().getWSTWebPreferences().getStaticWebContentFolderName();
        return webContentFolder;
    }
}

