/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.web.internal.WSTWebPreferences;
import org.osgi.framework.Bundle;

public class WSTWebPlugin
extends AbstractUIPlugin {
    private static WSTWebPlugin plugin;
    private WSTWebPreferences preferences;
    public static final String PLUGIN_ID = "com.ibm.etools.webtools.staticwebproject";
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    public static final String[] ICON_DIRS;

    static {
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/ctool16", "icons/full/wizban", "icons", ""};
    }

    public WSTWebPlugin() {
        plugin = this;
    }

    public static WSTWebPlugin getDefault() {
        return plugin;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = WSTWebPlugin.getImageURL(key, this.getBundle());
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    public static URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        int i = 0;
        while (i < ICON_DIRS.length) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (bundle.getEntry(path.toString()) != null) {
                try {
                    return new URL(bundle.getEntry("/"), path.toString());
                }
                catch (MalformedURLException exception) {
                    Logger.getLogger().logWarning("Load_Image_Error_");
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPluginPreferences() {
        this.getWSTWebPreferences().initializeDefaultPreferences();
    }

    public WSTWebPreferences getWSTWebPreferences() {
        if (this.preferences == null) {
            this.preferences = new WSTWebPreferences((Plugin)this);
        }
        return this.preferences;
    }
}

