/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lomboz.ws.axis.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.objectweb.lomboz.ws.axis.core.AxisPlugin;
import org.objectweb.lomboz.ws.axis.core.AxisPreferenceStore;
import org.objectweb.lomboz.ws.axis.core.AxisRuntime;
import org.objectweb.lomboz.ws.axis.core.ClasspathRuntimeTargetHandler;
import org.objectweb.lomboz.ws.axis.core.EmitterOption;
import org.objectweb.lomboz.ws.axis.core.Namespace;
import org.objectweb.lomboz.ws.axis.core.Trace;
import org.objectweb.lomboz.ws.axis.core.Wsdl2JavaOptions;
import org.objectweb.lomboz.ws.axis.ui.wizards.NameSpaceDialog;

public class AxisWsdl2JavaWizardPage
extends NewElementWizardPage {
    private Label wsdlLocationLabel;
    private Label outputLocationLabel;
    private Label typeVersionLabel;
    private Label usernameLabel;
    private Label passwordLabel;
    private Label packageNameLabel;
    private Text outputLocationField;
    private Text wsdlLocationField;
    private Text usernameField;
    private Text passwordField;
    private Text packageNameField;
    private Button wsdlLocationBrowseButton;
    private Button outputBrowseButton;
    private Button[] optionChecks;
    private ArrayList descriptors;
    private Combo typeVersionCombo;
    private ListDialogField nameSpaceDialogField;
    private IPackageFragmentRoot outputLoc;
    private Button addAxisButton;
    private IStructuredSelection selection;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public AxisWsdl2JavaWizardPage(String name) {
        super(name);
        this.setTitle("WSDL2Java");
    }

    public void init(IStructuredSelection selection) {
        if (selection != null && !selection.isEmpty()) {
            this.selection = selection;
        }
    }

    private void initWsdlFile(IStructuredSelection selection) {
        IResource resource;
        if (selection == null) {
            return;
        }
        IAdaptable adaptable = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)adaptable.getAdapter((Class)clazz)) != null && resource.getType() == 1 && resource.getFileExtension().equals("wsdl")) {
            this.wsdlLocationField.setText(resource.getLocation().toOSString());
        }
    }

    private void initOutputLocation(IStructuredSelection selection) {
        if (selection == null) {
            return;
        }
        IJavaElement elem = this.getInitialJavaElement(selection);
        IPackageFragmentRoot initRoot = null;
        if (elem != null && ((initRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)elem)) == null || initRoot.isArchive())) {
            IJavaProject jproject = elem.getJavaProject();
            try {
                initRoot = null;
                IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        initRoot = roots[i];
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((IStatus)e.getStatus());
            }
            if (initRoot == null) {
                initRoot = jproject.getPackageFragmentRoot("");
            }
        }
        this.outputLocationField.setText(initRoot.getPath().toString());
        this.outputLoc = initRoot;
    }

    private IJavaElement getInitialJavaElement(IStructuredSelection selection) {
        IJavaElement jelem;
        if (selection == null) {
            return null;
        }
        IAdaptable selected = (IAdaptable)selection.getFirstElement();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((jelem = (IJavaElement)selected.getAdapter((Class)clazz)) == null) {
            IResource resource;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)selected.getAdapter((Class)clazz2)) != null && resource.getType() != 8) {
                while (jelem == null && resource.getType() != 4) {
                    resource = resource.getParent();
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    jelem = (IJavaElement)resource.getAdapter((Class)clazz3);
                }
                if (jelem == null) {
                    jelem = JavaCore.create((IResource)resource);
                }
            }
        }
        return jelem;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int numOfCols = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = numOfCols;
        composite.setLayout((Layout)layout);
        this.createWSDLSelectDialog(composite, numOfCols);
        this.createOutputDirectoryGroup(composite, numOfCols);
        this.createTypeVersionField(composite, numOfCols);
        this.createSelectBoxGroup(composite, numOfCols);
        this.createPackageNameGroup(composite, numOfCols);
        this.createUserGroup(composite, numOfCols);
        composite.update();
        this.setControl((Control)composite);
        this.validateWSDLLocation();
        IPath statepath = AxisPlugin.getDefault().getStateLocation();
        IPath stateFilePath = statepath.append("/wsdl2javans2p.properties");
        this.importNamespace2Package(stateFilePath.toFile());
    }

    private void createUserGroup(Composite parent, int numOfCols) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numOfCols;
        group.setLayoutData((Object)gd);
        group.setText("Connect using");
        this.usernameLabel = new Label((Composite)group, 0);
        this.usernameLabel.setText("User name:");
        int fieldWidth = 175;
        this.usernameField = new Text((Composite)group, 2048);
        GridData uData = new GridData();
        uData.widthHint = fieldWidth;
        this.usernameField.setLayoutData((Object)uData);
        this.createEmptySpace((Composite)group, 1);
        this.passwordLabel = new Label((Composite)group, 0);
        this.passwordLabel.setText("Password:");
        this.passwordField = new Text((Composite)group, 2048);
        GridData pData = new GridData();
        pData.widthHint = fieldWidth;
        this.passwordField.setLayoutData((Object)pData);
        this.createEmptySpace((Composite)group, 1);
    }

    private void createPackageNameGroup(Composite parent, int numOfCols) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(832);
        gd.horizontalSpan = numOfCols;
        group.setLayoutData((Object)gd);
        group.setText("Namespace mapping");
        this.packageNameLabel = new Label((Composite)group, 0);
        this.packageNameLabel.setText("Package: ");
        this.packageNameLabel.setLayoutData((Object)new GridData(256));
        this.packageNameLabel.setToolTipText(Wsdl2JavaOptions.OPT_PACKAGE.getDescription());
        this.packageNameField = new Text((Composite)group, 2048);
        this.packageNameField.setLayoutData((Object)new GridData(768));
        this.packageNameField.setToolTipText(Wsdl2JavaOptions.OPT_PACKAGE.getDescription());
        this.packageNameField.addKeyListener((KeyListener)new TextFieldListener());
        this.createEmptySpace((Composite)group, 1);
        String[] labels = new String[]{"Add...", "Remove", "Import..."};
        this.nameSpaceDialogField = new ListDialogField((IListAdapter)new ListAdapter(), labels, (ILabelProvider)new NameSpaceListLabelProvider());
        this.nameSpaceDialogField.setLabelText("Namespace:");
        this.nameSpaceDialogField.doFillIntoGrid((Composite)group, 3);
        this.nameSpaceDialogField.setRemoveButtonIndex(1);
    }

    private void validatePackageName() {
        StatusInfo status = new StatusInfo();
        if (this.isPackageNameSpecified()) {
            if (JavaConventions.validatePackageName((String)this.packageNameField.getText()).getSeverity() != 0) {
                status = JavaConventions.validatePackageName((String)this.packageNameField.getText());
            }
            if (status.getSeverity() == 0 && this.nameSpaceDialogField.getSize() > 0) {
                status.setError("Namespace conversion is already specified");
            }
        }
        this.updateStatus((IStatus)status);
    }

    private void createSelectBoxGroup(Composite parent, int numOfCols) {
        Composite selectsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        selectsComposite.setLayout((Layout)layout);
        GridData groupGridData = new GridData(576);
        groupGridData.horizontalSpan = numOfCols;
        selectsComposite.setLayoutData((Object)groupGridData);
        Wsdl2JavaOptions.OptionDescriptor[] opts = Wsdl2JavaOptions.getOptions();
        ArrayList<Button> optionChecksList = new ArrayList<Button>();
        this.descriptors = new ArrayList();
        int i = 0;
        while (i < opts.length) {
            Wsdl2JavaOptions.OptionDescriptor descriptor = opts[i];
            AxisPreferenceStore.isPropertyActive(descriptor);
            switch (descriptor.getType()) {
                case 1: 
                case 4: {
                    this.descriptors.add(descriptor);
                    Button optButton = new Button(selectsComposite, 32);
                    optButton.setText(descriptor.getName());
                    optButton.setToolTipText(descriptor.getDescription());
                    optButton.setSelection(AxisPreferenceStore.isPropertyActive(descriptor));
                    optionChecksList.add(optButton);
                }
            }
            ++i;
        }
        this.optionChecks = new Button[optionChecksList.size()];
        this.optionChecks = optionChecksList.toArray(this.optionChecks);
        this.addAxisButton = new Button(selectsComposite, 32);
        this.addAxisButton.setText("Add Axis to buildpath");
        this.addAxisButton.setSelection(!this.isAxisOnBuildPath());
    }

    private void createTypeVersionField(Composite parent, int numOfCols) {
        this.typeVersionLabel = new Label(parent, 0);
        this.typeVersionLabel.setText("Type version: ");
        this.typeVersionLabel.setEnabled(true);
        this.typeVersionCombo = new Combo(parent, 4);
        this.typeVersionCombo.add("1.1");
        this.typeVersionCombo.add("1.2");
        this.typeVersionCombo.setText("1.1");
        this.typeVersionCombo.setEnabled(true);
        int item = "1.1".equals(AxisPreferenceStore.getProperty(Wsdl2JavaOptions.OPT_TYPEMAPPING)) ? 0 : 1;
        this.typeVersionCombo.select(item);
        this.createEmptySpace(parent, 1);
    }

    private void createOutputDirectoryGroup(Composite parent, int numOfCols) {
        this.outputLocationLabel = new Label(parent, 0);
        this.outputLocationLabel.setText("Generate in:");
        this.outputLocationLabel.setEnabled(true);
        this.outputLocationField = new Text(parent, 2048);
        this.outputLocationField.setLayoutData((Object)new GridData(768));
        this.outputLocationField.setEnabled(true);
        this.outputLocationField.addKeyListener((KeyListener)new TextFieldListener());
        this.outputBrowseButton = new Button(parent, 8);
        this.outputBrowseButton.setText("Browse..");
        this.outputBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AxisWsdl2JavaWizardPage.this.handleOutputLocationBrowseButtonPressed();
            }
        });
        this.outputBrowseButton.setEnabled(true);
        this.initOutputLocation(this.selection);
    }

    private void handleOutputLocationBrowseButtonPressed() {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.IJavaModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.jdt.core.IJavaProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        JavaElementLabelProvider lp = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        StandardJavaElementContentProvider cp = new StandardJavaElementContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle("Generate In");
        dialog.setMessage("Choose directory:");
        dialog.addFilter((ViewerFilter)filter);
        IWorkspaceRoot res = ResourcesPlugin.getWorkspace().getRoot();
        dialog.setInput((Object)JavaCore.create((IResource)res));
        if (this.outputLoc != null) {
            dialog.setInitialSelection((Object)this.outputLoc);
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                this.outputLoc = jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            } else if (element instanceof IPackageFragmentRoot) {
                this.outputLoc = (IPackageFragmentRoot)element;
            }
            this.outputLocationField.setText(this.outputLoc.getPath().toString());
            this.validateOutputLocation();
        }
    }

    private void createWSDLSelectDialog(Composite parent, int numOfCols) {
        String toolTip = "Enter a file name or URL";
        this.wsdlLocationLabel = new Label(parent, 0);
        this.wsdlLocationLabel.setText("WSDL File:");
        this.wsdlLocationLabel.setToolTipText(toolTip);
        this.wsdlLocationLabel.setEnabled(true);
        this.wsdlLocationField = new Text(parent, 2048);
        GridData data = new GridData(768);
        this.wsdlLocationField.setLayoutData((Object)data);
        this.wsdlLocationField.setEnabled(true);
        this.wsdlLocationField.setToolTipText(toolTip);
        this.wsdlLocationField.addKeyListener((KeyListener)new TextFieldListener());
        this.wsdlLocationBrowseButton = new Button(parent, 8);
        this.wsdlLocationBrowseButton.setText("Browse..");
        this.wsdlLocationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AxisWsdl2JavaWizardPage.this.handleWSDLLocationBrowseButtonPressed();
            }
        });
        this.wsdlLocationBrowseButton.setEnabled(true);
        this.initWsdlFile(this.selection);
    }

    private void handleWSDLLocationBrowseButtonPressed() {
        FileDialog fileDialog = new FileDialog(this.getWizard().getContainer().getShell());
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.wsdlLocationField.setText(fileName);
        }
        this.validateWSDLLocation();
    }

    public Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void validateWSDLLocation() {
        StatusInfo status = new StatusInfo();
        String wsdl = this.wsdlLocationField.getText();
        if (wsdl == null || wsdl.length() < 1) {
            status.setError("A WSDL file must be specified");
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(wsdl);
            if (res == null) {
                status.setWarning(String.valueOf(wsdl) + " does not exist in the workspace");
            }
        }
        this.updateStatus((IStatus)status);
    }

    private void validateOutputLocation() {
        StatusInfo status = new StatusInfo();
        this.outputLoc = null;
        String str = this.outputLocationField.getText();
        if (str.length() == 0) {
            status.setError("Source folder can not be empty");
            this.updateStatus((IStatus)status);
            return;
        }
        Path path = new Path(str);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError("Project " + proj.getFullPath().toString() + " is closed.");
                    this.updateStatus((IStatus)status);
                    return;
                }
                IJavaProject jproject = JavaCore.create((IProject)proj);
                this.outputLoc = jproject.getPackageFragmentRoot(res);
                if (res.exists()) {
                    try {
                        if (!proj.hasNature("org.eclipse.jdt.core.javanature")) {
                            if (resType == 4) {
                                status.setWarning("Not a java project");
                            } else {
                                status.setWarning("Not in a java project");
                            }
                            this.updateStatus((IStatus)status);
                            return;
                        }
                    }
                    catch (CoreException coreException) {
                        status.setWarning("Not a java Project");
                    }
                    if (!jproject.isOnClasspath((IJavaElement)this.outputLoc)) {
                        status.setWarning(String.valueOf(str) + " is not on the classpath");
                    }
                    if (this.outputLoc.isArchive()) {
                        status.setError(String.valueOf(str) + " is in binary form");
                        this.updateStatus((IStatus)status);
                        return;
                    }
                }
                return;
            }
            status.setError(String.valueOf(str) + " is not a Folder");
            this.updateStatus((IStatus)status);
            return;
        }
        status.setError(String.valueOf(str) + " does not exist");
        this.updateStatus((IStatus)status);
    }

    public EmitterOption[] prepareOptions() {
        List namespaces;
        if (this.addAxisButton.getSelection()) {
            this.addAxistoBuildpath(this.getOutputLoc().getJavaProject());
        }
        ArrayList<EmitterOption> options = new ArrayList<EmitterOption>();
        options.add(new EmitterOption(0, this.wsdlLocationField.getText()));
        if (!this.typeVersionCombo.getText().equals("1.1")) {
            options.add(new EmitterOption(84, this.typeVersionCombo.getText()));
        }
        int i = 0;
        while (i < this.optionChecks.length) {
            Button optBut = this.optionChecks[i];
            Wsdl2JavaOptions.OptionDescriptor descriptor = (Wsdl2JavaOptions.OptionDescriptor)this.descriptors.get(i);
            options.add(new EmitterOption(descriptor.getId(), String.valueOf(optBut.getSelection())));
            ++i;
        }
        if (this.isPackageNameSpecified()) {
            options.add(new EmitterOption(112, this.packageNameField.getText()));
        }
        options.add(new EmitterOption(85, this.usernameField.getText()));
        options.add(new EmitterOption(80, this.passwordField.getText()));
        if (!this.isPackageNameSpecified() && (namespaces = this.nameSpaceDialogField.getElements()) != null) {
            HashMap<String, String> map = new HashMap<String, String>(namespaces.size());
            int i2 = 0;
            while (i2 < namespaces.size()) {
                Namespace currElm = (Namespace)namespaces.get(i2);
                map.put(currElm.getNamespace(), currElm.getPackageName());
                ++i2;
            }
            options.add(new EmitterOption(78, map));
        }
        if (this.outputLoc != null) {
            try {
                options.add(new EmitterOption(111, this.outputLoc.getCorrespondingResource().getLocation().toOSString()));
            }
            catch (JavaModelException mdEx) {
                JavaPlugin.log((Throwable)mdEx);
            }
        }
        return options.toArray(new EmitterOption[options.size()]);
    }

    private void addAxistoBuildpath(IJavaProject prj) {
        try {
            ClasspathRuntimeTargetHandler handler = new ClasspathRuntimeTargetHandler();
            handler.setRuntimeTarget(prj.getProject(), AxisRuntime.getPreferredRuntime(), null);
        }
        catch (CoreException e) {
            Trace.trace(Trace.WARNING, "Ubale to set Axis libraries", e);
        }
    }

    public IPackageFragmentRoot getOutputLoc() {
        return this.outputLoc;
    }

    private boolean isPackageNameSpecified() {
        return this.packageNameField.getText().length() > 0;
    }

    private boolean isAxisOnBuildPath() {
        if (this.getOutputLoc() == null) {
            return false;
        }
        IJavaProject pr = this.getOutputLoc().getJavaProject();
        IPackageFragmentRoot[] roots = null;
        try {
            roots = pr.getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
        int i = 0;
        while (roots != null && i < roots.length) {
            if (roots[i] != null && roots[i].getElementName().endsWith("axis.jar")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void importNamespace2Package(File f) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 115->119)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class TextFieldListener
    implements KeyListener {
        TextFieldListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getSource() == AxisWsdl2JavaWizardPage.this.wsdlLocationField) {
                AxisWsdl2JavaWizardPage.this.validateWSDLLocation();
            }
            if (e.getSource() == AxisWsdl2JavaWizardPage.this.outputLocationField) {
                AxisWsdl2JavaWizardPage.this.validateOutputLocation();
            }
            if (e.getSource() == AxisWsdl2JavaWizardPage.this.packageNameField) {
                AxisWsdl2JavaWizardPage.this.validatePackageName();
            }
        }
    }

    private class NameSpaceListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage;

        public Image getImage(Object element) {
            return AxisPlugin.createImageDescriptor(AxisPlugin.getDefault().getBundle().getEntry("/"), "icons/full/ctool16/nspace.jpg").createImage();
        }
    }

    private class ListAdapter
    implements IListAdapter {
        ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (AxisWsdl2JavaWizardPage.this.isPackageNameSpecified()) {
                StatusInfo status = new StatusInfo();
                status.setError("Namespace is already specified via provided package name");
                AxisWsdl2JavaWizardPage.this.updateStatus((IStatus)status);
                return;
            }
            switch (index) {
                case 0: {
                    NameSpaceDialog dialog = new NameSpaceDialog(AxisWsdl2JavaWizardPage.this.getContainer().getShell(), "", "", null, null);
                    if (dialog.open() != 0) break;
                    AxisWsdl2JavaWizardPage.this.nameSpaceDialogField.addElement((Object)dialog.getNamespace());
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    FileDialog fileDlg = new FileDialog(AxisWsdl2JavaWizardPage.this.getContainer().getShell());
                    fileDlg.setText(Wsdl2JavaOptions.OPT_FILENSTOPKG.getDescription());
                    fileDlg.setFilterExtensions(new String[]{"*.properties"});
                    fileDlg.setFileName(Wsdl2JavaOptions.OPT_FILENSTOPKG.getValue());
                    String propFile = fileDlg.open();
                    File f = new File(propFile);
                    if (propFile == null) break;
                    AxisWsdl2JavaWizardPage.this.importNamespace2Package(f);
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

