/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lomboz.ws.axis.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectweb.lomboz.ws.axis.core.AxisRuntime;
import org.objectweb.lomboz.ws.axis.core.RuntimeClasspathContainer;
import org.objectweb.lomboz.ws.axis.core.Trace;

public class ClasspathRuntimeTargetHandler {
    public void setRuntimeTarget(IProject project, AxisRuntime runtime, IProgressMonitor monitor) throws CoreException {
        if (project == null || runtime == null) {
            return;
        }
        IJavaProject javaProject = null;
        try {
            javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
        }
        catch (Exception exception) {}
        if (javaProject == null) {
            return;
        }
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            ArrayList<IClasspathEntry> add = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] cp = javaProject.getRawClasspath();
            int size = cp.length;
            int i = 0;
            while (i < size) {
                if (cp[i].getEntryKind() == 5) {
                    if (!cp[i].getPath().segment(0).equals("org.eclipse.jst.ws.axis.container")) {
                        list.add(cp[i]);
                    }
                } else {
                    list.add(cp[i]);
                }
                ++i;
            }
            String[] ids = this.getClasspathEntryIds(runtime);
            if (ids != null) {
                size = ids.length;
                int i2 = 0;
                while (i2 < size) {
                    Path path = new Path("org.eclipse.jst.ws.axis.container");
                    if (ids[i2] != null) {
                        path.append(ids[i2]);
                    }
                    add.add(JavaCore.newContainerEntry((IPath)path));
                    RuntimeClasspathContainer rcc = new RuntimeClasspathContainer((IPath)path, this, runtime, "Axis");
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{rcc}, (IProgressMonitor)monitor);
                    ++i2;
                }
            }
            this.cleanupDuplicateClasspath(javaProject, list, add);
            Iterator iterator = add.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            cp = new IClasspathEntry[list.size()];
            list.toArray(cp);
            javaProject.setRawClasspath(cp, monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Error setting runtime target", e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.ws.axis", 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    protected void cleanupDuplicateClasspath(IJavaProject project, List current, List add) {
        IClasspathEntry entry;
        boolean sourceOnly = true;
        Iterator iterator = current.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry2 = (IClasspathEntry)iterator.next();
            if (entry2.getEntryKind() == 3) continue;
            sourceOnly = false;
        }
        if (sourceOnly) {
            return;
        }
        ArrayList<IClasspathEntry> remove = new ArrayList<IClasspathEntry>();
        iterator = current.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry3 = (IClasspathEntry)iterator.next();
            if (entry3.getEntryKind() != 5) continue;
            try {
                if (!"org.eclipse.jst.ws.axis.container".equals(entry3.getPath().segment(0))) continue;
                remove.add(entry3);
            }
            catch (Exception e) {
                Trace.trace(Trace.FINEST, "Error resolving classpath container", e);
            }
        }
        ArrayList<IClasspathEntry> addExpanded = new ArrayList<IClasspathEntry>();
        iterator = add.iterator();
        while (iterator.hasNext()) {
            entry = (IClasspathEntry)iterator.next();
            if (entry.getEntryKind() == 5) {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int size = entries.length;
                    int i = 0;
                    while (i < size) {
                        if (entries[i] != null) {
                            addExpanded.add(entries[i]);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.FINEST, "Error resolving classpath container 2", e);
                }
                continue;
            }
            if (entry.getEntryKind() == 4) {
                if ((entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) == null) continue;
                addExpanded.add(entry);
                continue;
            }
            addExpanded.add(entry);
        }
        iterator = current.iterator();
        while (iterator.hasNext()) {
            entry = (IClasspathEntry)iterator.next();
            ArrayList<IClasspathEntry> currentExpanded = new ArrayList<IClasspathEntry>();
            if (entry.getEntryKind() == 5) {
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] entries = container.getClasspathEntries();
                    int size = entries.length;
                    int i = 0;
                    while (i < size) {
                        if (entries[i] != null) {
                            currentExpanded.add(entries[i]);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Trace.trace(Trace.FINEST, "Error resolving classpath container 3", e);
                }
            } else if (entry.getEntryKind() == 4) {
                if ((entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry)) != null) {
                    currentExpanded.add(entry);
                }
            } else {
                currentExpanded.add(entry);
            }
            boolean dup = false;
            Iterator iterator2 = currentExpanded.iterator();
            while (!dup && iterator2.hasNext()) {
                IClasspathEntry entry2 = (IClasspathEntry)iterator2.next();
                Iterator iterator3 = addExpanded.iterator();
                while (iterator3.hasNext()) {
                    IClasspathEntry entry3 = (IClasspathEntry)iterator3.next();
                    if (!entry3.getPath().equals((Object)entry2.getPath())) continue;
                    dup = true;
                }
            }
            if (!dup || remove.contains(entry)) continue;
            remove.add(entry);
        }
        iterator = remove.iterator();
        while (iterator.hasNext()) {
            current.remove(iterator.next());
        }
    }

    protected static void addJarFiles(File dir, List list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        ClasspathRuntimeTargetHandler.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List list, int depth) {
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    ClasspathRuntimeTargetHandler.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List list, File dir, boolean includeSubdirectories) {
        ClasspathRuntimeTargetHandler.addJarFiles(dir, list, includeSubdirectories);
    }

    protected static void addLibraryEntry(List list, File dir) {
        Path path = new Path(dir.getAbsolutePath());
        list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
    }

    protected static void addLibraryEntry(List list, IPath path) {
        list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
    }

    protected static void addLibraryEntry(List list, IPath path, IPath source, IPath root) {
        list.add(JavaCore.newLibraryEntry((IPath)path, (IPath)source, (IPath)root));
    }

    protected static IClasspathEntry[] resolveList(List list) {
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        list.toArray(entries);
        return entries;
    }

    public IClasspathEntry[] getDelegateClasspathEntries(AxisRuntime runtime, IProgressMonitor monitor) {
        return null;
    }

    public String[] getClasspathEntryIds(AxisRuntime runtime) {
        return new String[]{"Axis"};
    }
}

