/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.lomboz.ws.axis.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.objectweb.lomboz.ws.axis.core.AxisPreferenceStore;

public class AxisRuntime {
    public static final String ID = "Axis";
    public static final String LIBPATH = "lib";
    public static final String[] VERSIONS = new String[]{"1.0", "1.1", "1.2"};
    private String version = "1.1";
    private String home = "";
    private String[] libs = new String[]{"axis", "axis-ant", "commons-discovery", "commons-logging", "log4j", "jaxrpc", "saaj", "wsdl4j"};

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String[] getLibs() {
        return this.libs;
    }

    public IClasspathEntry[] resolveClasspathContainer() {
        ArrayList list = new ArrayList();
        AxisRuntime.addLibraryEntries(list, new File(String.valueOf(this.home) + File.separator + LIBPATH), false);
        return AxisRuntime.resolveList(list);
    }

    protected static void addJarFiles(File dir, List list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        AxisRuntime.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List list, int depth) {
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    AxisRuntime.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List list, File dir, boolean includeSubdirectories) {
        AxisRuntime.addJarFiles(dir, list, includeSubdirectories);
    }

    protected static IClasspathEntry[] resolveList(List list) {
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        list.toArray(entries);
        return entries;
    }

    public static AxisRuntime getPreferredRuntime() {
        AxisRuntime axisRuntime = new AxisRuntime();
        axisRuntime.setHome(AxisPreferenceStore.getProperty("AXIS", "home"));
        axisRuntime.setVersion(AxisPreferenceStore.getProperty("AXIS", "version"));
        return axisRuntime;
    }

    public URL getHomeURL() throws MalformedURLException {
        return new File(this.getHome()).toURL();
    }

    public IStatus[] validate() {
        ArrayList<Status> errors = new ArrayList<Status>();
        File axisHome = new File(this.getHome());
        File axisHomeLib = new File(String.valueOf(this.getHome()) + File.separator + LIBPATH);
        if (!axisHomeLib.exists() || axisHomeLib.isDirectory()) {
            // empty if block
        }
        if ((axisHome = axisHomeLib).isDirectory()) {
            File[] files = axisHome.listFiles();
            int i = 0;
            while (i < this.libs.length) {
                String jar = this.libs[i];
                boolean found = false;
                int j = 0;
                while (j < files.length) {
                    File file = files[j];
                    String fName = file.getName();
                    if (fName.indexOf(jar) >= 0 && fName.indexOf(".jar") >= 0) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    errors.add(new Status(4, "org.eclipse.jst.ws.axis", 0, "Could not find library: " + jar, null));
                }
                ++i;
            }
        } else {
            errors.add(new Status(4, "org.eclipse.jst.ws.axis", 0, "Axis home is not a directory: " + this.getHome(), null));
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    public boolean isValid() {
        return this.validate().length == 0;
    }
}

